/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Map;
import redis.clients.jedis.BinaryTransaction;
import redis.clients.jedis.Client;
import redis.clients.jedis.SortingParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction
extends BinaryTransaction {
    public Transaction() {
    }

    public Transaction(Client client) {
        super(client);
    }

    public String set(String key, String value) {
        this.client.set(key, value);
        return this.client.getStatusCodeReply();
    }

    public String get(String key) {
        this.client.get(key);
        return this.client.getStatusCodeReply();
    }

    public String exists(String key) {
        this.client.exists(key);
        return this.client.getStatusCodeReply();
    }

    public String del(String ... keys) {
        this.client.del(keys);
        return this.client.getStatusCodeReply();
    }

    public String type(String key) {
        this.client.type(key);
        return this.client.getStatusCodeReply();
    }

    public String keys(String pattern) {
        this.client.keys(pattern);
        return this.client.getStatusCodeReply();
    }

    public String randomKey() {
        this.client.randomKey();
        return this.client.getBulkReply();
    }

    public String rename(String oldkey, String newkey) {
        this.client.rename(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    public String renamenx(String oldkey, String newkey) {
        this.client.renamenx(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    public String expire(String key, int seconds) {
        this.client.expire(key, seconds);
        return this.client.getStatusCodeReply();
    }

    public String expireAt(String key, long unixTime) {
        this.client.expireAt(key, unixTime);
        return this.client.getStatusCodeReply();
    }

    public String ttl(String key) {
        this.client.ttl(key);
        return this.client.getStatusCodeReply();
    }

    public String move(String key, int dbIndex) {
        this.client.move(key, dbIndex);
        return this.client.getStatusCodeReply();
    }

    public String getSet(String key, String value) {
        this.client.getSet(key, value);
        return this.client.getStatusCodeReply();
    }

    public String mget(String ... keys) {
        this.client.mget(keys);
        return this.client.getStatusCodeReply();
    }

    public String setnx(String key, String value) {
        this.client.setnx(key, value);
        return this.client.getStatusCodeReply();
    }

    public String setex(String key, int seconds, String value) {
        this.client.setex(key, seconds, value);
        return this.client.getStatusCodeReply();
    }

    public String mset(String ... keysvalues) {
        this.client.mset(keysvalues);
        return this.client.getStatusCodeReply();
    }

    public String msetnx(String ... keysvalues) {
        this.client.msetnx(keysvalues);
        return this.client.getStatusCodeReply();
    }

    public String decrBy(String key, int integer) {
        this.client.decrBy(key, integer);
        return this.client.getStatusCodeReply();
    }

    public String decr(String key) {
        this.client.decr(key);
        return this.client.getStatusCodeReply();
    }

    public String incrBy(String key, int integer) {
        this.client.incrBy(key, integer);
        return this.client.getStatusCodeReply();
    }

    public String incr(String key) {
        this.client.incr(key);
        return this.client.getStatusCodeReply();
    }

    public String append(String key, String value) {
        this.client.append(key, value);
        return this.client.getStatusCodeReply();
    }

    public String substr(String key, int start, int end) {
        this.client.substr(key, start, end);
        return this.client.getStatusCodeReply();
    }

    public String hset(String key, String field, String value) {
        this.client.hset(key, field, value);
        return this.client.getStatusCodeReply();
    }

    public String hget(String key, String field) {
        this.client.hget(key, field);
        return this.client.getStatusCodeReply();
    }

    public String hsetnx(String key, String field, String value) {
        this.client.hsetnx(key, field, value);
        return this.client.getStatusCodeReply();
    }

    public String hmset(String key, Map<String, String> hash) {
        this.client.hmset(key, hash);
        return this.client.getStatusCodeReply();
    }

    public String hmget(String key, String ... fields) {
        this.client.hmget(key, fields);
        return this.client.getStatusCodeReply();
    }

    public String hincrBy(String key, String field, int value) {
        this.client.hincrBy(key, field, value);
        return this.client.getStatusCodeReply();
    }

    public String hexists(String key, String field) {
        this.client.hexists(key, field);
        return this.client.getStatusCodeReply();
    }

    public String hdel(String key, String field) {
        this.client.hdel(key, field);
        return this.client.getStatusCodeReply();
    }

    public String hlen(String key) {
        this.client.hlen(key);
        return this.client.getStatusCodeReply();
    }

    public String hkeys(String key) {
        this.client.hkeys(key);
        return this.client.getStatusCodeReply();
    }

    public String hvals(String key) {
        this.client.hvals(key);
        return this.client.getStatusCodeReply();
    }

    public String hgetAll(String key) {
        this.client.hgetAll(key);
        return this.client.getStatusCodeReply();
    }

    public String rpush(String key, String string) {
        this.client.rpush(key, string);
        return this.client.getStatusCodeReply();
    }

    public String lpush(String key, String string) {
        this.client.lpush(key, string);
        return this.client.getStatusCodeReply();
    }

    public String llen(String key) {
        this.client.llen(key);
        return this.client.getStatusCodeReply();
    }

    public String lrange(String key, int start, int end) {
        this.client.lrange(key, start, end);
        return this.client.getStatusCodeReply();
    }

    public String ltrim(String key, int start, int end) {
        this.client.ltrim(key, start, end);
        return this.client.getStatusCodeReply();
    }

    public String lindex(String key, int index) {
        this.client.lindex(key, index);
        return this.client.getStatusCodeReply();
    }

    public String lset(String key, int index, String value) {
        this.client.lset(key, index, value);
        return this.client.getStatusCodeReply();
    }

    public String lrem(String key, int count, String value) {
        this.client.lrem(key, count, value);
        return this.client.getStatusCodeReply();
    }

    public String lpop(String key) {
        this.client.lpop(key);
        return this.client.getStatusCodeReply();
    }

    public String rpop(String key) {
        this.client.rpop(key);
        return this.client.getStatusCodeReply();
    }

    public String rpoplpush(String srckey, String dstkey) {
        this.client.rpoplpush(srckey, dstkey);
        return this.client.getStatusCodeReply();
    }

    public String sadd(String key, String member) {
        this.client.sadd(key, member);
        return this.client.getStatusCodeReply();
    }

    public String smembers(String key) {
        this.client.smembers(key);
        return this.client.getStatusCodeReply();
    }

    public String srem(String key, String member) {
        this.client.srem(key, member);
        return this.client.getStatusCodeReply();
    }

    public String spop(String key) {
        this.client.spop(key);
        return this.client.getStatusCodeReply();
    }

    public String smove(String srckey, String dstkey, String member) {
        this.client.smove(srckey, dstkey, member);
        return this.client.getStatusCodeReply();
    }

    public String scard(String key) {
        this.client.scard(key);
        return this.client.getStatusCodeReply();
    }

    public String sismember(String key, String member) {
        this.client.sismember(key, member);
        return this.client.getStatusCodeReply();
    }

    public String sinter(String ... keys) {
        this.client.sinter(keys);
        return this.client.getStatusCodeReply();
    }

    public String sinterstore(String dstkey, String ... keys) {
        this.client.sinterstore(dstkey, keys);
        return this.client.getStatusCodeReply();
    }

    public String sunion(String ... keys) {
        this.client.sunion(keys);
        return this.client.getStatusCodeReply();
    }

    public String sunionstore(String dstkey, String ... keys) {
        this.client.sunionstore(dstkey, keys);
        return this.client.getStatusCodeReply();
    }

    public String sdiff(String ... keys) {
        this.client.sdiff(keys);
        return this.client.getStatusCodeReply();
    }

    public String sdiffstore(String dstkey, String ... keys) {
        this.client.sdiffstore(dstkey, keys);
        return this.client.getStatusCodeReply();
    }

    public String srandmember(String key) {
        this.client.srandmember(key);
        return this.client.getStatusCodeReply();
    }

    public String zadd(String key, double score, String member) {
        this.client.zadd(key, score, member);
        return this.client.getStatusCodeReply();
    }

    public String zrange(String key, int start, int end) {
        this.client.zrange(key, start, end);
        return this.client.getStatusCodeReply();
    }

    public String zrem(String key, String member) {
        this.client.zrem(key, member);
        return this.client.getStatusCodeReply();
    }

    public String zincrby(String key, double score, String member) {
        this.client.zincrby(key, score, member);
        return this.client.getStatusCodeReply();
    }

    public String zrank(String key, String member) {
        this.client.zrank(key, member);
        return this.client.getStatusCodeReply();
    }

    public String zrevrank(String key, String member) {
        this.client.zrevrank(key, member);
        return this.client.getStatusCodeReply();
    }

    public String zrevrange(String key, int start, int end) {
        this.client.zrevrange(key, start, end);
        return this.client.getStatusCodeReply();
    }

    public String zrangeWithScores(String key, int start, int end) {
        this.client.zrangeWithScores(key, start, end);
        return this.client.getStatusCodeReply();
    }

    public String zrevrangeWithScores(String key, int start, int end) {
        this.client.zrevrangeWithScores(key, start, end);
        return this.client.getStatusCodeReply();
    }

    public String zcard(String key) {
        this.client.zcard(key);
        return this.client.getStatusCodeReply();
    }

    public String zscore(String key, String member) {
        this.client.zscore(key, member);
        return this.client.getStatusCodeReply();
    }

    public String sort(String key) {
        this.client.sort(key);
        return this.client.getStatusCodeReply();
    }

    public String sort(String key, SortingParams sortingParameters) {
        this.client.sort(key, sortingParameters);
        return this.client.getStatusCodeReply();
    }
}

