/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.Map;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.ZParams;
import redis.clients.util.SafeEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryClient
extends Connection {
    private boolean isInMulti;

    public boolean isInMulti() {
        return this.isInMulti;
    }

    public BinaryClient(String host) {
        super(host);
    }

    public BinaryClient(String host, int port) {
        super(host, port);
    }

    public void ping() {
        this.sendCommand(Protocol.Command.PING);
    }

    public void set(byte[] key, byte[] value) {
        this.sendCommand(Protocol.Command.SET, key, value);
    }

    public void get(byte[] key) {
        this.sendCommand(Protocol.Command.GET, new byte[][]{key});
    }

    public void quit() {
        this.sendCommand(Protocol.Command.QUIT);
    }

    public void exists(byte[] key) {
        this.sendCommand(Protocol.Command.EXISTS, new byte[][]{key});
    }

    public void del(byte[] ... keys) {
        this.sendCommand(Protocol.Command.DEL, keys);
    }

    public void type(byte[] key) {
        this.sendCommand(Protocol.Command.TYPE, new byte[][]{key});
    }

    public void flushDB() {
        this.sendCommand(Protocol.Command.FLUSHDB);
    }

    public void keys(byte[] pattern) {
        this.sendCommand(Protocol.Command.KEYS, new byte[][]{pattern});
    }

    public void randomKey() {
        this.sendCommand(Protocol.Command.RANDOMKEY);
    }

    public void rename(byte[] oldkey, byte[] newkey) {
        this.sendCommand(Protocol.Command.RENAME, oldkey, newkey);
    }

    public void renamenx(byte[] oldkey, byte[] newkey) {
        this.sendCommand(Protocol.Command.RENAMENX, oldkey, newkey);
    }

    public void dbSize() {
        this.sendCommand(Protocol.Command.DBSIZE);
    }

    public void expire(byte[] key, int seconds) {
        this.sendCommand(Protocol.Command.EXPIRE, key, Protocol.toByteArray(seconds));
    }

    public void expireAt(byte[] key, long unixTime) {
        this.sendCommand(Protocol.Command.EXPIREAT, key, Protocol.toByteArray(unixTime));
    }

    public void ttl(byte[] key) {
        this.sendCommand(Protocol.Command.TTL, new byte[][]{key});
    }

    public void select(int index) {
        this.sendCommand(Protocol.Command.SELECT, new byte[][]{Protocol.toByteArray(index)});
    }

    public void move(byte[] key, int dbIndex) {
        this.sendCommand(Protocol.Command.MOVE, key, Protocol.toByteArray(dbIndex));
    }

    public void flushAll() {
        this.sendCommand(Protocol.Command.FLUSHALL);
    }

    public void getSet(byte[] key, byte[] value) {
        this.sendCommand(Protocol.Command.GETSET, key, value);
    }

    public void mget(byte[] ... keys) {
        this.sendCommand(Protocol.Command.MGET, keys);
    }

    public void setnx(byte[] key, byte[] value) {
        this.sendCommand(Protocol.Command.SETNX, key, value);
    }

    public void setex(byte[] key, int seconds, byte[] value) {
        this.sendCommand(Protocol.Command.SETEX, key, Protocol.toByteArray(seconds), value);
    }

    public void mset(byte[] ... keysvalues) {
        this.sendCommand(Protocol.Command.MSET, keysvalues);
    }

    public void msetnx(byte[] ... keysvalues) {
        this.sendCommand(Protocol.Command.MSETNX, keysvalues);
    }

    public void decrBy(byte[] key, long integer) {
        this.sendCommand(Protocol.Command.DECRBY, key, Protocol.toByteArray(integer));
    }

    public void decr(byte[] key) {
        this.sendCommand(Protocol.Command.DECR, new byte[][]{key});
    }

    public void incrBy(byte[] key, long integer) {
        this.sendCommand(Protocol.Command.INCRBY, key, Protocol.toByteArray(integer));
    }

    public void incr(byte[] key) {
        this.sendCommand(Protocol.Command.INCR, new byte[][]{key});
    }

    public void append(byte[] key, byte[] value) {
        this.sendCommand(Protocol.Command.APPEND, key, value);
    }

    public void substr(byte[] key, int start, int end) {
        this.sendCommand(Protocol.Command.SUBSTR, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void hset(byte[] key, byte[] field, byte[] value) {
        this.sendCommand(Protocol.Command.HSET, key, field, value);
    }

    public void hget(byte[] key, byte[] field) {
        this.sendCommand(Protocol.Command.HGET, key, field);
    }

    public void hsetnx(byte[] key, byte[] field, byte[] value) {
        this.sendCommand(Protocol.Command.HSETNX, key, field, value);
    }

    public void hmset(byte[] key, Map<byte[], byte[]> hash) {
        ArrayList<byte[]> params = new ArrayList<byte[]>();
        params.add(key);
        for (byte[] field : hash.keySet()) {
            params.add(field);
            params.add(hash.get(field));
        }
        this.sendCommand(Protocol.Command.HMSET, (byte[][])params.toArray((T[])new byte[params.size()][]));
    }

    public void hmget(byte[] key, byte[] ... fields) {
        byte[][] params = new byte[fields.length + 1][];
        params[0] = key;
        System.arraycopy(fields, 0, params, 1, fields.length);
        this.sendCommand(Protocol.Command.HMGET, params);
    }

    public void hincrBy(byte[] key, byte[] field, long value) {
        this.sendCommand(Protocol.Command.HINCRBY, key, field, Protocol.toByteArray(value));
    }

    public void hexists(byte[] key, byte[] field) {
        this.sendCommand(Protocol.Command.HEXISTS, key, field);
    }

    public void hdel(byte[] key, byte[] field) {
        this.sendCommand(Protocol.Command.HDEL, key, field);
    }

    public void hlen(byte[] key) {
        this.sendCommand(Protocol.Command.HLEN, new byte[][]{key});
    }

    public void hkeys(byte[] key) {
        this.sendCommand(Protocol.Command.HKEYS, new byte[][]{key});
    }

    public void hvals(byte[] key) {
        this.sendCommand(Protocol.Command.HVALS, new byte[][]{key});
    }

    public void hgetAll(byte[] key) {
        this.sendCommand(Protocol.Command.HGETALL, new byte[][]{key});
    }

    public void rpush(byte[] key, byte[] string) {
        this.sendCommand(Protocol.Command.RPUSH, key, string);
    }

    public void lpush(byte[] key, byte[] string) {
        this.sendCommand(Protocol.Command.LPUSH, key, string);
    }

    public void llen(byte[] key) {
        this.sendCommand(Protocol.Command.LLEN, new byte[][]{key});
    }

    public void lrange(byte[] key, int start, int end) {
        this.sendCommand(Protocol.Command.LRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void ltrim(byte[] key, int start, int end) {
        this.sendCommand(Protocol.Command.LTRIM, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void lindex(byte[] key, int index) {
        this.sendCommand(Protocol.Command.LINDEX, key, Protocol.toByteArray(index));
    }

    public void lset(byte[] key, int index, byte[] value) {
        this.sendCommand(Protocol.Command.LSET, key, Protocol.toByteArray(index), value);
    }

    public void lrem(byte[] key, int count, byte[] value) {
        this.sendCommand(Protocol.Command.LREM, key, Protocol.toByteArray(count), value);
    }

    public void lpop(byte[] key) {
        this.sendCommand(Protocol.Command.LPOP, new byte[][]{key});
    }

    public void rpop(byte[] key) {
        this.sendCommand(Protocol.Command.RPOP, new byte[][]{key});
    }

    public void rpoplpush(byte[] srckey, byte[] dstkey) {
        this.sendCommand(Protocol.Command.RPOPLPUSH, srckey, dstkey);
    }

    public void sadd(byte[] key, byte[] member) {
        this.sendCommand(Protocol.Command.SADD, key, member);
    }

    public void smembers(byte[] key) {
        this.sendCommand(Protocol.Command.SMEMBERS, new byte[][]{key});
    }

    public void srem(byte[] key, byte[] member) {
        this.sendCommand(Protocol.Command.SREM, key, member);
    }

    public void spop(byte[] key) {
        this.sendCommand(Protocol.Command.SPOP, new byte[][]{key});
    }

    public void smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.sendCommand(Protocol.Command.SMOVE, srckey, dstkey, member);
    }

    public void scard(byte[] key) {
        this.sendCommand(Protocol.Command.SCARD, new byte[][]{key});
    }

    public void sismember(byte[] key, byte[] member) {
        this.sendCommand(Protocol.Command.SISMEMBER, key, member);
    }

    public void sinter(byte[] ... keys) {
        this.sendCommand(Protocol.Command.SINTER, keys);
    }

    public void sinterstore(byte[] dstkey, byte[] ... keys) {
        byte[][] params = new byte[keys.length + 1][];
        params[0] = dstkey;
        System.arraycopy(keys, 0, params, 1, keys.length);
        this.sendCommand(Protocol.Command.SINTERSTORE, params);
    }

    public void sunion(byte[] ... keys) {
        this.sendCommand(Protocol.Command.SUNION, keys);
    }

    public void sunionstore(byte[] dstkey, byte[] ... keys) {
        byte[][] params = new byte[keys.length + 1][];
        params[0] = dstkey;
        System.arraycopy(keys, 0, params, 1, keys.length);
        this.sendCommand(Protocol.Command.SUNIONSTORE, params);
    }

    public void sdiff(byte[] ... keys) {
        this.sendCommand(Protocol.Command.SDIFF, keys);
    }

    public void sdiffstore(byte[] dstkey, byte[] ... keys) {
        byte[][] params = new byte[keys.length + 1][];
        params[0] = dstkey;
        System.arraycopy(keys, 0, params, 1, keys.length);
        this.sendCommand(Protocol.Command.SDIFFSTORE, params);
    }

    public void srandmember(byte[] key) {
        this.sendCommand(Protocol.Command.SRANDMEMBER, new byte[][]{key});
    }

    public void zadd(byte[] key, double score, byte[] member) {
        this.sendCommand(Protocol.Command.ZADD, key, Protocol.toByteArray(score), member);
    }

    public void zrange(byte[] key, int start, int end) {
        this.sendCommand(Protocol.Command.ZRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void zrem(byte[] key, byte[] member) {
        this.sendCommand(Protocol.Command.ZREM, key, member);
    }

    public void zincrby(byte[] key, double score, byte[] member) {
        this.sendCommand(Protocol.Command.ZINCRBY, key, Protocol.toByteArray(score), member);
    }

    public void zrank(byte[] key, byte[] member) {
        this.sendCommand(Protocol.Command.ZRANK, key, member);
    }

    public void zrevrank(byte[] key, byte[] member) {
        this.sendCommand(Protocol.Command.ZREVRANK, key, member);
    }

    public void zrevrange(byte[] key, int start, int end) {
        this.sendCommand(Protocol.Command.ZREVRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void zrangeWithScores(byte[] key, int start, int end) {
        this.sendCommand(Protocol.Command.ZRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(end), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeWithScores(byte[] key, int start, int end) {
        this.sendCommand(Protocol.Command.ZREVRANGE, key, Protocol.toByteArray(start), Protocol.toByteArray(end), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zcard(byte[] key) {
        this.sendCommand(Protocol.Command.ZCARD, new byte[][]{key});
    }

    public void zscore(byte[] key, byte[] member) {
        this.sendCommand(Protocol.Command.ZSCORE, key, member);
    }

    public void multi() {
        this.sendCommand(Protocol.Command.MULTI);
        this.isInMulti = true;
    }

    public void discard() {
        this.sendCommand(Protocol.Command.DISCARD);
        this.isInMulti = false;
    }

    public void exec() {
        this.sendCommand(Protocol.Command.EXEC);
        this.isInMulti = false;
    }

    public void watch(byte[] ... keys) {
        this.sendCommand(Protocol.Command.WATCH, keys);
    }

    public void unwatch() {
        this.sendCommand(Protocol.Command.UNWATCH);
    }

    public void sort(byte[] key) {
        this.sendCommand(Protocol.Command.SORT, new byte[][]{key});
    }

    public void sort(byte[] key, SortingParams sortingParameters) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        this.sendCommand(Protocol.Command.SORT, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void blpop(byte[][] args) {
        this.sendCommand(Protocol.Command.BLPOP, args);
    }

    public void sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        args.add(Protocol.Keyword.STORE.raw);
        args.add(dstkey);
        this.sendCommand(Protocol.Command.SORT, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void sort(byte[] key, byte[] dstkey) {
        this.sendCommand(Protocol.Command.SORT, key, Protocol.Keyword.STORE.raw, dstkey);
    }

    public void brpop(byte[][] args) {
        this.sendCommand(Protocol.Command.BRPOP, args);
    }

    public void auth(String password) {
        this.sendCommand(Protocol.Command.AUTH, password);
    }

    public void subscribe(String ... channels) {
        this.sendCommand(Protocol.Command.SUBSCRIBE, channels);
    }

    public void publish(String channel, String message) {
        this.sendCommand(Protocol.Command.PUBLISH, channel, message);
    }

    public void unsubscribe() {
        this.sendCommand(Protocol.Command.UNSUBSCRIBE);
    }

    public void unsubscribe(String ... channels) {
        this.sendCommand(Protocol.Command.UNSUBSCRIBE, channels);
    }

    public void psubscribe(String[] patterns) {
        this.sendCommand(Protocol.Command.PSUBSCRIBE, patterns);
    }

    public void punsubscribe() {
        this.sendCommand(Protocol.Command.PUNSUBSCRIBE);
    }

    public void punsubscribe(String ... patterns) {
        this.sendCommand(Protocol.Command.PUNSUBSCRIBE, patterns);
    }

    public void zcount(byte[] key, double min, double max) {
        this.sendCommand(Protocol.Command.ZCOUNT, key, Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    public void zrangeByScore(byte[] key, double min, double max) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    public void zrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, min, max);
    }

    public void zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min), Protocol.toByteArray(max), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count));
    }

    public void zrangeByScoreWithScores(byte[] key, double min, double max) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min), Protocol.toByteArray(max), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        this.sendCommand(Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min), Protocol.toByteArray(max), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zremrangeByRank(byte[] key, int start, int end) {
        this.sendCommand(Protocol.Command.ZREMRANGEBYRANK, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void zremrangeByScore(byte[] key, double start, double end) {
        this.sendCommand(Protocol.Command.ZREMRANGEBYSCORE, key, Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    public void zunionstore(byte[] dstkey, byte[] ... sets) {
        byte[][] params = new byte[sets.length + 2][];
        params[0] = dstkey;
        params[1] = Protocol.toByteArray(sets.length);
        System.arraycopy(sets, 0, params, 2, sets.length);
        this.sendCommand(Protocol.Command.ZUNIONSTORE, params);
    }

    public void zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(dstkey);
        args.add(Protocol.toByteArray(sets.length));
        for (byte[] set : sets) {
            args.add(set);
        }
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.ZUNIONSTORE, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void zinterstore(byte[] dstkey, byte[] ... sets) {
        byte[][] params = new byte[sets.length + 2][];
        params[0] = dstkey;
        params[1] = Protocol.toByteArray(sets.length);
        System.arraycopy(sets, 0, params, 2, sets.length);
        this.sendCommand(Protocol.Command.ZINTERSTORE, params);
    }

    public void zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(dstkey);
        args.add(Protocol.toByteArray(sets.length));
        for (byte[] set : sets) {
            args.add(set);
        }
        args.addAll(params.getParams());
        this.sendCommand(Protocol.Command.ZINTERSTORE, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void save() {
        this.sendCommand(Protocol.Command.SAVE);
    }

    public void bgsave() {
        this.sendCommand(Protocol.Command.BGSAVE);
    }

    public void bgrewriteaof() {
        this.sendCommand(Protocol.Command.BGREWRITEAOF);
    }

    public void lastsave() {
        this.sendCommand(Protocol.Command.LASTSAVE);
    }

    public void shutdown() {
        this.sendCommand(Protocol.Command.SHUTDOWN);
    }

    public void info() {
        this.sendCommand(Protocol.Command.INFO);
    }

    public void monitor() {
        this.sendCommand(Protocol.Command.MONITOR);
    }

    public void slaveof(String host, int port) {
        this.sendCommand(Protocol.Command.SLAVEOF, host, String.valueOf(port));
    }

    public void slaveofNoOne() {
        this.sendCommand(Protocol.Command.SLAVEOF, Protocol.Keyword.NO.raw, Protocol.Keyword.ONE.raw);
    }

    public void configGet(String pattern) {
        this.sendCommand(Protocol.Command.CONFIG, Protocol.Keyword.GET.name(), pattern);
    }

    public void configSet(String parameter, String value) {
        this.sendCommand(Protocol.Command.CONFIG, Protocol.Keyword.SET.name(), parameter, value);
    }

    public void strlen(byte[] key) {
        this.sendCommand(Protocol.Command.STRLEN, new byte[][]{key});
    }

    public void sync() {
        this.sendCommand(Protocol.Command.SYNC);
    }

    public void lpushx(byte[] key, byte[] string) {
        this.sendCommand(Protocol.Command.LPUSHX, key, string);
    }

    public void persist(byte[] key) {
        this.sendCommand(Protocol.Command.PERSIST, new byte[][]{key});
    }

    public void rpushx(byte[] key, byte[] string) {
        this.sendCommand(Protocol.Command.RPUSHX, key, string);
    }

    public void echo(byte[] string) {
        this.sendCommand(Protocol.Command.ECHO, new byte[][]{string});
    }

    public void linsert(byte[] key, LIST_POSITION where, byte[] pivot, byte[] value) {
        this.sendCommand(Protocol.Command.LINSERT, key, where.raw, pivot, value);
    }

    public void debug(DebugParams params) {
        this.sendCommand(Protocol.Command.DEBUG, params.getCommand());
    }

    public void brpoplpush(byte[] source, byte[] destination, int timeout) {
        this.sendCommand(Protocol.Command.BRPOPLPUSH, source, destination, Protocol.toByteArray(timeout));
    }

    public void configResetStat() {
        this.sendCommand(Protocol.Command.CONFIG, Protocol.Keyword.RESETSTAT.name());
    }

    public void setbit(byte[] key, int offset, byte[] value) {
        this.sendCommand(Protocol.Command.SETBIT, key, Protocol.toByteArray(offset), value);
    }

    public void getbit(byte[] key, int offset) {
        this.sendCommand(Protocol.Command.GETBIT, key, Protocol.toByteArray(offset));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LIST_POSITION {
        BEFORE,
        AFTER;

        public final byte[] raw = SafeEncoder.encode(this.name());
    }
}

