/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.net.URI;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisFactory;
import redis.clients.util.Pool;

public class JedisPool
extends Pool<Jedis> {
    public JedisPool(GenericObjectPool.Config poolConfig, String host) {
        this(poolConfig, host, 6379, 2000, null, 0);
    }

    public JedisPool(String host, int port) {
        this(new GenericObjectPool.Config(), host, port, 2000, null, 0);
    }

    public JedisPool(String host) {
        URI uri = URI.create(host);
        if (uri.getScheme() != null && uri.getScheme().equals("redis")) {
            String h = uri.getHost();
            int port = uri.getPort();
            String password = uri.getUserInfo().split(":", 2)[1];
            int database = Integer.parseInt(uri.getPath().split("/", 2)[1]);
            this.internalPool = new GenericObjectPool((PoolableObjectFactory)new JedisFactory(h, port, 2000, password, database), new GenericObjectPool.Config());
        } else {
            this.internalPool = new GenericObjectPool((PoolableObjectFactory)new JedisFactory(host, 6379, 2000, null, 0), new GenericObjectPool.Config());
        }
    }

    public JedisPool(URI uri) {
        String h = uri.getHost();
        int port = uri.getPort();
        String password = uri.getUserInfo().split(":", 2)[1];
        int database = Integer.parseInt(uri.getPath().split("/", 2)[1]);
        this.internalPool = new GenericObjectPool((PoolableObjectFactory)new JedisFactory(h, port, 2000, password, database), new GenericObjectPool.Config());
    }

    public JedisPool(GenericObjectPool.Config poolConfig, String host, int port, int timeout, String password) {
        this(poolConfig, host, port, timeout, password, 0);
    }

    public JedisPool(GenericObjectPool.Config poolConfig, String host, int port) {
        this(poolConfig, host, port, 2000, null, 0);
    }

    public JedisPool(GenericObjectPool.Config poolConfig, String host, int port, int timeout) {
        this(poolConfig, host, port, timeout, null, 0);
    }

    public JedisPool(GenericObjectPool.Config poolConfig, String host, int port, int timeout, String password, int database) {
        super(poolConfig, (PoolableObjectFactory)new JedisFactory(host, port, timeout, password, database));
    }

    @Override
    public void returnBrokenResource(BinaryJedis resource) {
        this.returnBrokenResourceObject(resource);
    }

    @Override
    public void returnResource(BinaryJedis resource) {
        this.returnResourceObject(resource);
    }
}

