/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.Commands;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.ZParams;
import redis.clients.util.SafeEncoder;

public class Client
extends BinaryClient
implements Commands {
    public Client(String host) {
        super(host);
    }

    public Client(String host, int port) {
        super(host, port);
    }

    @Override
    public void set(String key, String value) {
        this.set(SafeEncoder.encode(key), SafeEncoder.encode(value));
    }

    @Override
    public void set(String key, String value, String nxxx, String expx, long time) {
        this.set(SafeEncoder.encode(key), SafeEncoder.encode(value), SafeEncoder.encode(nxxx), SafeEncoder.encode(expx), time);
    }

    @Override
    public void get(String key) {
        this.get(SafeEncoder.encode(key));
    }

    @Override
    public void exists(String key) {
        this.exists(SafeEncoder.encode(key));
    }

    @Override
    public void del(String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < keys.length; ++i) {
            bkeys[i] = SafeEncoder.encode(keys[i]);
        }
        this.del(bkeys);
    }

    @Override
    public void type(String key) {
        this.type(SafeEncoder.encode(key));
    }

    @Override
    public void keys(String pattern) {
        this.keys(SafeEncoder.encode(pattern));
    }

    @Override
    public void rename(String oldkey, String newkey) {
        this.rename(SafeEncoder.encode(oldkey), SafeEncoder.encode(newkey));
    }

    @Override
    public void renamenx(String oldkey, String newkey) {
        this.renamenx(SafeEncoder.encode(oldkey), SafeEncoder.encode(newkey));
    }

    @Override
    public void expire(String key, int seconds) {
        this.expire(SafeEncoder.encode(key), seconds);
    }

    @Override
    public void expireAt(String key, long unixTime) {
        this.expireAt(SafeEncoder.encode(key), unixTime);
    }

    @Override
    public void ttl(String key) {
        this.ttl(SafeEncoder.encode(key));
    }

    @Override
    public void move(String key, int dbIndex) {
        this.move(SafeEncoder.encode(key), dbIndex);
    }

    @Override
    public void getSet(String key, String value) {
        this.getSet(SafeEncoder.encode(key), SafeEncoder.encode(value));
    }

    @Override
    public void mget(String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < bkeys.length; ++i) {
            bkeys[i] = SafeEncoder.encode(keys[i]);
        }
        this.mget(bkeys);
    }

    @Override
    public void setnx(String key, String value) {
        this.setnx(SafeEncoder.encode(key), SafeEncoder.encode(value));
    }

    @Override
    public void setex(String key, int seconds, String value) {
        this.setex(SafeEncoder.encode(key), seconds, SafeEncoder.encode(value));
    }

    @Override
    public void mset(String ... keysvalues) {
        byte[][] bkeysvalues = new byte[keysvalues.length][];
        for (int i = 0; i < keysvalues.length; ++i) {
            bkeysvalues[i] = SafeEncoder.encode(keysvalues[i]);
        }
        this.mset(bkeysvalues);
    }

    @Override
    public void msetnx(String ... keysvalues) {
        byte[][] bkeysvalues = new byte[keysvalues.length][];
        for (int i = 0; i < keysvalues.length; ++i) {
            bkeysvalues[i] = SafeEncoder.encode(keysvalues[i]);
        }
        this.msetnx(bkeysvalues);
    }

    @Override
    public void decrBy(String key, long integer) {
        this.decrBy(SafeEncoder.encode(key), integer);
    }

    @Override
    public void decr(String key) {
        this.decr(SafeEncoder.encode(key));
    }

    @Override
    public void incrBy(String key, long integer) {
        this.incrBy(SafeEncoder.encode(key), integer);
    }

    @Override
    public void incr(String key) {
        this.incr(SafeEncoder.encode(key));
    }

    @Override
    public void append(String key, String value) {
        this.append(SafeEncoder.encode(key), SafeEncoder.encode(value));
    }

    @Override
    public void substr(String key, int start, int end) {
        this.substr(SafeEncoder.encode(key), start, end);
    }

    @Override
    public void hset(String key, String field, String value) {
        this.hset(SafeEncoder.encode(key), SafeEncoder.encode(field), SafeEncoder.encode(value));
    }

    @Override
    public void hget(String key, String field) {
        this.hget(SafeEncoder.encode(key), SafeEncoder.encode(field));
    }

    @Override
    public void hsetnx(String key, String field, String value) {
        this.hsetnx(SafeEncoder.encode(key), SafeEncoder.encode(field), SafeEncoder.encode(value));
    }

    @Override
    public void hmset(String key, Map<String, String> hash) {
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>(hash.size());
        for (Map.Entry<String, String> entry : hash.entrySet()) {
            bhash.put(SafeEncoder.encode(entry.getKey()), SafeEncoder.encode(entry.getValue()));
        }
        this.hmset(SafeEncoder.encode(key), bhash);
    }

    @Override
    public void hmget(String key, String ... fields) {
        byte[][] bfields = new byte[fields.length][];
        for (int i = 0; i < bfields.length; ++i) {
            bfields[i] = SafeEncoder.encode(fields[i]);
        }
        this.hmget(SafeEncoder.encode(key), bfields);
    }

    @Override
    public void hincrBy(String key, String field, long value) {
        this.hincrBy(SafeEncoder.encode(key), SafeEncoder.encode(field), value);
    }

    @Override
    public void hexists(String key, String field) {
        this.hexists(SafeEncoder.encode(key), SafeEncoder.encode(field));
    }

    @Override
    public void hdel(String key, String ... fields) {
        this.hdel(SafeEncoder.encode(key), SafeEncoder.encodeMany(fields));
    }

    @Override
    public void hlen(String key) {
        this.hlen(SafeEncoder.encode(key));
    }

    @Override
    public void hkeys(String key) {
        this.hkeys(SafeEncoder.encode(key));
    }

    @Override
    public void hvals(String key) {
        this.hvals(SafeEncoder.encode(key));
    }

    @Override
    public void hgetAll(String key) {
        this.hgetAll(SafeEncoder.encode(key));
    }

    @Override
    public void rpush(String key, String ... string) {
        this.rpush(SafeEncoder.encode(key), SafeEncoder.encodeMany(string));
    }

    @Override
    public void lpush(String key, String ... string) {
        this.lpush(SafeEncoder.encode(key), SafeEncoder.encodeMany(string));
    }

    @Override
    public void llen(String key) {
        this.llen(SafeEncoder.encode(key));
    }

    @Override
    public void lrange(String key, long start, long end) {
        this.lrange(SafeEncoder.encode(key), start, end);
    }

    @Override
    public void ltrim(String key, long start, long end) {
        this.ltrim(SafeEncoder.encode(key), start, end);
    }

    @Override
    public void lindex(String key, long index) {
        this.lindex(SafeEncoder.encode(key), index);
    }

    @Override
    public void lset(String key, long index, String value) {
        this.lset(SafeEncoder.encode(key), index, SafeEncoder.encode(value));
    }

    @Override
    public void lrem(String key, long count, String value) {
        this.lrem(SafeEncoder.encode(key), count, SafeEncoder.encode(value));
    }

    @Override
    public void lpop(String key) {
        this.lpop(SafeEncoder.encode(key));
    }

    @Override
    public void rpop(String key) {
        this.rpop(SafeEncoder.encode(key));
    }

    @Override
    public void rpoplpush(String srckey, String dstkey) {
        this.rpoplpush(SafeEncoder.encode(srckey), SafeEncoder.encode(dstkey));
    }

    @Override
    public void sadd(String key, String ... members) {
        this.sadd(SafeEncoder.encode(key), SafeEncoder.encodeMany(members));
    }

    @Override
    public void smembers(String key) {
        this.smembers(SafeEncoder.encode(key));
    }

    @Override
    public void srem(String key, String ... members) {
        this.srem(SafeEncoder.encode(key), SafeEncoder.encodeMany(members));
    }

    @Override
    public void spop(String key) {
        this.spop(SafeEncoder.encode(key));
    }

    @Override
    public void smove(String srckey, String dstkey, String member) {
        this.smove(SafeEncoder.encode(srckey), SafeEncoder.encode(dstkey), SafeEncoder.encode(member));
    }

    @Override
    public void scard(String key) {
        this.scard(SafeEncoder.encode(key));
    }

    @Override
    public void sismember(String key, String member) {
        this.sismember(SafeEncoder.encode(key), SafeEncoder.encode(member));
    }

    @Override
    public void sinter(String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < bkeys.length; ++i) {
            bkeys[i] = SafeEncoder.encode(keys[i]);
        }
        this.sinter(bkeys);
    }

    @Override
    public void sinterstore(String dstkey, String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < bkeys.length; ++i) {
            bkeys[i] = SafeEncoder.encode(keys[i]);
        }
        this.sinterstore(SafeEncoder.encode(dstkey), bkeys);
    }

    @Override
    public void sunion(String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < bkeys.length; ++i) {
            bkeys[i] = SafeEncoder.encode(keys[i]);
        }
        this.sunion(bkeys);
    }

    @Override
    public void sunionstore(String dstkey, String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < bkeys.length; ++i) {
            bkeys[i] = SafeEncoder.encode(keys[i]);
        }
        this.sunionstore(SafeEncoder.encode(dstkey), bkeys);
    }

    @Override
    public void sdiff(String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < bkeys.length; ++i) {
            bkeys[i] = SafeEncoder.encode(keys[i]);
        }
        this.sdiff(bkeys);
    }

    @Override
    public void sdiffstore(String dstkey, String ... keys) {
        byte[][] bkeys = new byte[keys.length][];
        for (int i = 0; i < bkeys.length; ++i) {
            bkeys[i] = SafeEncoder.encode(keys[i]);
        }
        this.sdiffstore(SafeEncoder.encode(dstkey), bkeys);
    }

    @Override
    public void srandmember(String key) {
        this.srandmember(SafeEncoder.encode(key));
    }

    @Override
    public void zadd(String key, double score, String member) {
        this.zadd(SafeEncoder.encode(key), score, SafeEncoder.encode(member));
    }

    @Override
    public void zrange(String key, long start, long end) {
        this.zrange(SafeEncoder.encode(key), start, end);
    }

    @Override
    public void zrem(String key, String ... members) {
        this.zrem(SafeEncoder.encode(key), SafeEncoder.encodeMany(members));
    }

    @Override
    public void zincrby(String key, double score, String member) {
        this.zincrby(SafeEncoder.encode(key), score, SafeEncoder.encode(member));
    }

    @Override
    public void zrank(String key, String member) {
        this.zrank(SafeEncoder.encode(key), SafeEncoder.encode(member));
    }

    @Override
    public void zrevrank(String key, String member) {
        this.zrevrank(SafeEncoder.encode(key), SafeEncoder.encode(member));
    }

    @Override
    public void zrevrange(String key, long start, long end) {
        this.zrevrange(SafeEncoder.encode(key), start, end);
    }

    @Override
    public void zrangeWithScores(String key, long start, long end) {
        this.zrangeWithScores(SafeEncoder.encode(key), start, end);
    }

    @Override
    public void zrevrangeWithScores(String key, long start, long end) {
        this.zrevrangeWithScores(SafeEncoder.encode(key), start, end);
    }

    @Override
    public void zcard(String key) {
        this.zcard(SafeEncoder.encode(key));
    }

    @Override
    public void zscore(String key, String member) {
        this.zscore(SafeEncoder.encode(key), SafeEncoder.encode(member));
    }

    @Override
    public void watch(String ... keys) {
        byte[][] bargs = new byte[keys.length][];
        for (int i = 0; i < bargs.length; ++i) {
            bargs[i] = SafeEncoder.encode(keys[i]);
        }
        this.watch(bargs);
    }

    @Override
    public void sort(String key) {
        this.sort(SafeEncoder.encode(key));
    }

    @Override
    public void sort(String key, SortingParams sortingParameters) {
        this.sort(SafeEncoder.encode(key), sortingParameters);
    }

    @Override
    public void blpop(String[] args) {
        byte[][] bargs = new byte[args.length][];
        for (int i = 0; i < bargs.length; ++i) {
            bargs[i] = SafeEncoder.encode(args[i]);
        }
        this.blpop(bargs);
    }

    public void blpop(int timeout, String ... keys) {
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : keys) {
            args.add(arg);
        }
        args.add(String.valueOf(timeout));
        this.blpop(args.toArray(new String[args.size()]));
    }

    @Override
    public void sort(String key, SortingParams sortingParameters, String dstkey) {
        this.sort(SafeEncoder.encode(key), sortingParameters, SafeEncoder.encode(dstkey));
    }

    @Override
    public void sort(String key, String dstkey) {
        this.sort(SafeEncoder.encode(key), SafeEncoder.encode(dstkey));
    }

    @Override
    public void brpop(String[] args) {
        byte[][] bargs = new byte[args.length][];
        for (int i = 0; i < bargs.length; ++i) {
            bargs[i] = SafeEncoder.encode(args[i]);
        }
        this.brpop(bargs);
    }

    public void brpop(int timeout, String ... keys) {
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : keys) {
            args.add(arg);
        }
        args.add(String.valueOf(timeout));
        this.brpop(args.toArray(new String[args.size()]));
    }

    @Override
    public void zcount(String key, double min, double max) {
        this.zcount(SafeEncoder.encode(key), Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    @Override
    public void zcount(String key, String min, String max) {
        this.zcount(SafeEncoder.encode(key), SafeEncoder.encode(min), SafeEncoder.encode(max));
    }

    @Override
    public void zrangeByScore(String key, double min, double max) {
        this.zrangeByScore(SafeEncoder.encode(key), Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    @Override
    public void zrangeByScore(String key, String min, String max) {
        this.zrangeByScore(SafeEncoder.encode(key), SafeEncoder.encode(min), SafeEncoder.encode(max));
    }

    @Override
    public void zrangeByScore(String key, double min, double max, int offset, int count) {
        this.zrangeByScore(SafeEncoder.encode(key), Protocol.toByteArray(min), Protocol.toByteArray(max), offset, count);
    }

    @Override
    public void zrangeByScoreWithScores(String key, double min, double max) {
        this.zrangeByScoreWithScores(SafeEncoder.encode(key), Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    @Override
    public void zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        this.zrangeByScoreWithScores(SafeEncoder.encode(key), Protocol.toByteArray(min), Protocol.toByteArray(max), offset, count);
    }

    @Override
    public void zrevrangeByScore(String key, double max, double min) {
        this.zrevrangeByScore(SafeEncoder.encode(key), Protocol.toByteArray(max), Protocol.toByteArray(min));
    }

    public void zrangeByScore(String key, String min, String max, int offset, int count) {
        this.zrangeByScore(SafeEncoder.encode(key), SafeEncoder.encode(min), SafeEncoder.encode(max), offset, count);
    }

    @Override
    public void zrangeByScoreWithScores(String key, String min, String max) {
        this.zrangeByScoreWithScores(SafeEncoder.encode(key), SafeEncoder.encode(min), SafeEncoder.encode(max));
    }

    @Override
    public void zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        this.zrangeByScoreWithScores(SafeEncoder.encode(key), SafeEncoder.encode(min), SafeEncoder.encode(max), offset, count);
    }

    @Override
    public void zrevrangeByScore(String key, String max, String min) {
        this.zrevrangeByScore(SafeEncoder.encode(key), SafeEncoder.encode(max), SafeEncoder.encode(min));
    }

    @Override
    public void zrevrangeByScore(String key, double max, double min, int offset, int count) {
        this.zrevrangeByScore(SafeEncoder.encode(key), Protocol.toByteArray(max), Protocol.toByteArray(min), offset, count);
    }

    public void zrevrangeByScore(String key, String max, String min, int offset, int count) {
        this.zrevrangeByScore(SafeEncoder.encode(key), SafeEncoder.encode(max), SafeEncoder.encode(min), offset, count);
    }

    @Override
    public void zrevrangeByScoreWithScores(String key, double max, double min) {
        this.zrevrangeByScoreWithScores(SafeEncoder.encode(key), Protocol.toByteArray(max), Protocol.toByteArray(min));
    }

    @Override
    public void zrevrangeByScoreWithScores(String key, String max, String min) {
        this.zrevrangeByScoreWithScores(SafeEncoder.encode(key), SafeEncoder.encode(max), SafeEncoder.encode(min));
    }

    @Override
    public void zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        this.zrevrangeByScoreWithScores(SafeEncoder.encode(key), Protocol.toByteArray(max), Protocol.toByteArray(min), offset, count);
    }

    @Override
    public void zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        this.zrevrangeByScoreWithScores(SafeEncoder.encode(key), SafeEncoder.encode(max), SafeEncoder.encode(min), offset, count);
    }

    @Override
    public void zremrangeByRank(String key, long start, long end) {
        this.zremrangeByRank(SafeEncoder.encode(key), start, end);
    }

    @Override
    public void zremrangeByScore(String key, double start, double end) {
        this.zremrangeByScore(SafeEncoder.encode(key), Protocol.toByteArray(start), Protocol.toByteArray(end));
    }

    @Override
    public void zremrangeByScore(String key, String start, String end) {
        this.zremrangeByScore(SafeEncoder.encode(key), SafeEncoder.encode(start), SafeEncoder.encode(end));
    }

    @Override
    public void zunionstore(String dstkey, String ... sets) {
        byte[][] bsets = new byte[sets.length][];
        for (int i = 0; i < bsets.length; ++i) {
            bsets[i] = SafeEncoder.encode(sets[i]);
        }
        this.zunionstore(SafeEncoder.encode(dstkey), bsets);
    }

    @Override
    public void zunionstore(String dstkey, ZParams params, String ... sets) {
        byte[][] bsets = new byte[sets.length][];
        for (int i = 0; i < bsets.length; ++i) {
            bsets[i] = SafeEncoder.encode(sets[i]);
        }
        this.zunionstore(SafeEncoder.encode(dstkey), params, (byte[][])bsets);
    }

    @Override
    public void zinterstore(String dstkey, String ... sets) {
        byte[][] bsets = new byte[sets.length][];
        for (int i = 0; i < bsets.length; ++i) {
            bsets[i] = SafeEncoder.encode(sets[i]);
        }
        this.zinterstore(SafeEncoder.encode(dstkey), bsets);
    }

    @Override
    public void zinterstore(String dstkey, ZParams params, String ... sets) {
        byte[][] bsets = new byte[sets.length][];
        for (int i = 0; i < bsets.length; ++i) {
            bsets[i] = SafeEncoder.encode(sets[i]);
        }
        this.zinterstore(SafeEncoder.encode(dstkey), params, (byte[][])bsets);
    }

    @Override
    public void strlen(String key) {
        this.strlen(SafeEncoder.encode(key));
    }

    @Override
    public void lpushx(String key, String ... string) {
        this.lpushx(SafeEncoder.encode(key), this.getByteParams(string));
    }

    @Override
    public void persist(String key) {
        this.persist(SafeEncoder.encode(key));
    }

    @Override
    public void rpushx(String key, String ... string) {
        this.rpushx(SafeEncoder.encode(key), this.getByteParams(string));
    }

    @Override
    public void echo(String string) {
        this.echo(SafeEncoder.encode(string));
    }

    @Override
    public void linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        this.linsert(SafeEncoder.encode(key), where, SafeEncoder.encode(pivot), SafeEncoder.encode(value));
    }

    @Override
    public void brpoplpush(String source, String destination, int timeout) {
        this.brpoplpush(SafeEncoder.encode(source), SafeEncoder.encode(destination), timeout);
    }

    @Override
    public void setbit(String key, long offset, boolean value) {
        this.setbit(SafeEncoder.encode(key), offset, value);
    }

    @Override
    public void setbit(String key, long offset, String value) {
        this.setbit(SafeEncoder.encode(key), offset, SafeEncoder.encode(value));
    }

    @Override
    public void getbit(String key, long offset) {
        this.getbit(SafeEncoder.encode(key), offset);
    }

    @Override
    public void setrange(String key, long offset, String value) {
        this.setrange(SafeEncoder.encode(key), offset, SafeEncoder.encode(value));
    }

    @Override
    public void getrange(String key, long startOffset, long endOffset) {
        this.getrange(SafeEncoder.encode(key), startOffset, endOffset);
    }

    public void publish(String channel, String message) {
        this.publish(SafeEncoder.encode(channel), SafeEncoder.encode(message));
    }

    public void unsubscribe(String ... channels) {
        byte[][] cs = new byte[channels.length][];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = SafeEncoder.encode(channels[i]);
        }
        this.unsubscribe(cs);
    }

    public void psubscribe(String ... patterns) {
        byte[][] ps = new byte[patterns.length][];
        for (int i = 0; i < ps.length; ++i) {
            ps[i] = SafeEncoder.encode(patterns[i]);
        }
        this.psubscribe(ps);
    }

    public void punsubscribe(String ... patterns) {
        byte[][] ps = new byte[patterns.length][];
        for (int i = 0; i < ps.length; ++i) {
            ps[i] = SafeEncoder.encode(patterns[i]);
        }
        this.punsubscribe(ps);
    }

    public void subscribe(String ... channels) {
        byte[][] cs = new byte[channels.length][];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = SafeEncoder.encode(channels[i]);
        }
        this.subscribe(cs);
    }

    public void pubsubChannels(String pattern) {
        this.pubsub("channels", pattern);
    }

    public void pubsubNumPat() {
        this.pubsub("numpat", new String[0]);
    }

    public void pubsubNumSub(String ... channels) {
        this.pubsub("numsub", channels);
    }

    @Override
    public void configSet(String parameter, String value) {
        this.configSet(SafeEncoder.encode(parameter), SafeEncoder.encode(value));
    }

    @Override
    public void configGet(String pattern) {
        this.configGet(SafeEncoder.encode(pattern));
    }

    private byte[][] getByteParams(String ... params) {
        byte[][] p = new byte[params.length][];
        for (int i = 0; i < params.length; ++i) {
            p[i] = SafeEncoder.encode(params[i]);
        }
        return p;
    }

    public void eval(String script, int keyCount, String ... params) {
        this.eval(SafeEncoder.encode(script), Protocol.toByteArray(keyCount), this.getByteParams(params));
    }

    public void evalsha(String sha1, int keyCount, String ... params) {
        this.evalsha(SafeEncoder.encode(sha1), Protocol.toByteArray(keyCount), this.getByteParams(params));
    }

    public void scriptExists(String ... sha1) {
        byte[][] bsha1 = new byte[sha1.length][];
        for (int i = 0; i < bsha1.length; ++i) {
            bsha1[i] = SafeEncoder.encode(sha1[i]);
        }
        this.scriptExists(bsha1);
    }

    public void scriptLoad(String script) {
        this.scriptLoad(SafeEncoder.encode(script));
    }

    @Override
    public void zadd(String key, Map<String, Double> scoreMembers) {
        HashMap<byte[], Double> binaryScoreMembers = new HashMap<byte[], Double>();
        for (Map.Entry<String, Double> entry : scoreMembers.entrySet()) {
            binaryScoreMembers.put(SafeEncoder.encode(entry.getKey()), entry.getValue());
        }
        this.zaddBinary(SafeEncoder.encode(key), binaryScoreMembers);
    }

    @Override
    public void objectRefcount(String key) {
        this.objectRefcount(SafeEncoder.encode(key));
    }

    @Override
    public void objectIdletime(String key) {
        this.objectIdletime(SafeEncoder.encode(key));
    }

    @Override
    public void objectEncoding(String key) {
        this.objectEncoding(SafeEncoder.encode(key));
    }

    @Override
    public void bitcount(String key) {
        this.bitcount(SafeEncoder.encode(key));
    }

    @Override
    public void bitcount(String key, long start, long end) {
        this.bitcount(SafeEncoder.encode(key), start, end);
    }

    @Override
    public void bitop(BitOP op, String destKey, String ... srcKeys) {
        this.bitop(op, SafeEncoder.encode(destKey), this.getByteParams(srcKeys));
    }

    public void sentinel(String ... args) {
        byte[][] arg = new byte[args.length][];
        for (int i = 0; i < arg.length; ++i) {
            arg[i] = SafeEncoder.encode(args[i]);
        }
        this.sentinel(arg);
    }

    public void dump(String key) {
        this.dump(SafeEncoder.encode(key));
    }

    public void restore(String key, int ttl, byte[] serializedValue) {
        this.restore(SafeEncoder.encode(key), ttl, serializedValue);
    }

    public void pexpire(String key, int milliseconds) {
        this.pexpire(SafeEncoder.encode(key), milliseconds);
    }

    public void pexpireAt(String key, long millisecondsTimestamp) {
        this.pexpireAt(SafeEncoder.encode(key), millisecondsTimestamp);
    }

    public void pttl(String key) {
        this.pttl(SafeEncoder.encode(key));
    }

    public void incrByFloat(String key, double increment) {
        this.incrByFloat(SafeEncoder.encode(key), increment);
    }

    public void psetex(String key, int milliseconds, String value) {
        this.psetex(SafeEncoder.encode(key), milliseconds, SafeEncoder.encode(value));
    }

    public void set(String key, String value, String nxxx) {
        this.set(SafeEncoder.encode(key), SafeEncoder.encode(value), SafeEncoder.encode(nxxx));
    }

    public void set(String key, String value, String nxxx, String expx, int time) {
        this.set(SafeEncoder.encode(key), SafeEncoder.encode(value), SafeEncoder.encode(nxxx), SafeEncoder.encode(expx), time);
    }

    public void srandmember(String key, int count) {
        this.srandmember(SafeEncoder.encode(key), count);
    }

    public void clientKill(String client) {
        this.clientKill(SafeEncoder.encode(client));
    }

    public void clientSetname(String name) {
        this.clientSetname(SafeEncoder.encode(name));
    }

    public void migrate(String host, int port, String key, int destinationDb, int timeout) {
        this.migrate(SafeEncoder.encode(host), port, SafeEncoder.encode(key), destinationDb, timeout);
    }

    public void hincrByFloat(String key, String field, double increment) {
        this.hincrByFloat(SafeEncoder.encode(key), SafeEncoder.encode(field), increment);
    }

    @Override
    @Deprecated
    public void hscan(String key, int cursor, ScanParams params) {
        this.hscan(SafeEncoder.encode(key), cursor, params);
    }

    @Override
    @Deprecated
    public void sscan(String key, int cursor, ScanParams params) {
        this.sscan(SafeEncoder.encode(key), cursor, params);
    }

    @Override
    @Deprecated
    public void zscan(String key, int cursor, ScanParams params) {
        this.zscan(SafeEncoder.encode(key), cursor, params);
    }

    @Override
    public void scan(String cursor, ScanParams params) {
        this.scan(SafeEncoder.encode(cursor), params);
    }

    @Override
    public void hscan(String key, String cursor, ScanParams params) {
        this.hscan(SafeEncoder.encode(key), SafeEncoder.encode(cursor), params);
    }

    @Override
    public void sscan(String key, String cursor, ScanParams params) {
        this.sscan(SafeEncoder.encode(key), SafeEncoder.encode(cursor), params);
    }

    @Override
    public void zscan(String key, String cursor, ScanParams params) {
        this.zscan(SafeEncoder.encode(key), SafeEncoder.encode(cursor), params);
    }

    public void cluster(String subcommand, int ... args) {
        byte[][] arg = new byte[args.length + 1][];
        for (int i = 1; i < arg.length; ++i) {
            arg[i] = Protocol.toByteArray(args[i - 1]);
        }
        arg[0] = SafeEncoder.encode(subcommand);
        this.cluster(arg);
    }

    public void pubsub(String subcommand, String ... args) {
        byte[][] arg = new byte[args.length + 1][];
        for (int i = 1; i < arg.length; ++i) {
            arg[i] = SafeEncoder.encode(args[i - 1]);
        }
        arg[0] = SafeEncoder.encode(subcommand);
        this.pubsub(arg);
    }

    public void cluster(String subcommand, String ... args) {
        byte[][] arg = new byte[args.length + 1][];
        for (int i = 1; i < arg.length; ++i) {
            arg[i] = SafeEncoder.encode(args[i - 1]);
        }
        arg[0] = SafeEncoder.encode(subcommand);
        this.cluster(arg);
    }

    public void cluster(String subcommand) {
        byte[][] arg = new byte[][]{SafeEncoder.encode(subcommand)};
        this.cluster(arg);
    }

    public void clusterNodes() {
        this.cluster("nodes");
    }

    public void clusterMeet(String ip, int port) {
        this.cluster("meet", ip, String.valueOf(port));
    }

    public void clusterAddSlots(int ... slots) {
        this.cluster("addslots", slots);
    }

    public void clusterDelSlots(int ... slots) {
        this.cluster("delslots", slots);
    }

    public void clusterInfo() {
        this.cluster("info");
    }

    public void clusterGetKeysInSlot(int slot, int count) {
        int[] args = new int[]{slot, count};
        this.cluster("getkeysinslot", args);
    }

    public void clusterSetSlotNode(int slot, String nodeId) {
        this.cluster("setslot", String.valueOf(slot), "node", nodeId);
    }

    public void clusterSetSlotMigrating(int slot, String nodeId) {
        this.cluster("setslot", String.valueOf(slot), "migrating", nodeId);
    }

    public void clusterSetSlotImporting(int slot, String nodeId) {
        this.cluster("setslot", String.valueOf(slot), "importing", nodeId);
    }
}

