/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterInfoCache;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisConnectionException;

public abstract class JedisClusterConnectionHandler {
    protected final JedisClusterInfoCache cache;

    abstract Jedis getConnection();

    public void returnConnection(Jedis connection) {
        this.cache.getNode(JedisClusterInfoCache.getNodeKey(connection.getClient())).returnResource(connection);
    }

    public void returnBrokenConnection(Jedis connection) {
        this.cache.getNode(JedisClusterInfoCache.getNodeKey(connection.getClient())).returnBrokenResource(connection);
    }

    abstract Jedis getConnectionFromSlot(int var1);

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig) {
        this.cache = new JedisClusterInfoCache(poolConfig);
        this.initializeSlotsCache(nodes, poolConfig);
    }

    public Map<String, JedisPool> getNodes() {
        return this.cache.getNodes();
    }

    public void assignSlotToNode(int slot, HostAndPort targetNode) {
        this.cache.assignSlotToNode(slot, targetNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSlotsCache(Set<HostAndPort> startNodes, GenericObjectPoolConfig poolConfig) {
        for (HostAndPort hostAndPort : startNodes) {
            JedisPool jp = new JedisPool(poolConfig, hostAndPort.getHost(), hostAndPort.getPort());
            Jedis jedis = null;
            try {
                jedis = jp.getResource();
                this.cache.discoverClusterNodesAndSlots(jedis);
                break;
            }
            catch (JedisConnectionException e) {}
            continue;
            finally {
                if (jedis == null) continue;
                jedis.close();
            }
        }
        for (HostAndPort node : startNodes) {
            this.cache.setNodeIfNotExist(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewSlotCache() {
        Iterator<JedisPool> i$ = this.cache.getNodes().values().iterator();
        if (i$.hasNext()) {
            JedisPool jp = i$.next();
            Jedis jedis = null;
            try {
                jedis = jp.getResource();
                this.cache.discoverClusterSlots(jedis);
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
    }
}

