/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.regex.Pattern;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Connection;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.MultiNodePipelineBase;
import redis.clients.jedis.ShardedCommandArguments;
import redis.clients.jedis.ShardedCommandObjects;
import redis.clients.jedis.providers.ShardedConnectionProvider;

public class ShardedPipeline
extends MultiNodePipelineBase {
    private final ShardedConnectionProvider provider;

    public ShardedPipeline(ShardedConnectionProvider provider) {
        super(new ShardedCommandObjects(provider.getHashingAlgo()));
        this.provider = provider;
    }

    public ShardedPipeline(ShardedConnectionProvider provider, Pattern tagPattern) {
        super(new ShardedCommandObjects(provider.getHashingAlgo(), tagPattern));
        this.provider = provider;
    }

    @Override
    protected HostAndPort getNodeKey(CommandArguments args) {
        return this.provider.getNode(((ShardedCommandArguments)args).getKeyHash());
    }

    @Override
    protected Connection getConnection(HostAndPort nodeKey) {
        return this.provider.getConnection(nodeKey);
    }
}

