/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.DefaultJedisSocketFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.IOUtils;
import redis.clients.jedis.util.Pool;
import redis.clients.jedis.util.RedisInputStream;
import redis.clients.jedis.util.RedisOutputStream;
import redis.clients.jedis.util.SafeEncoder;

public class Connection
implements Closeable {
    private static final byte[][] EMPTY_ARGS = new byte[0][];
    private final Pool<Connection> memberOf;
    private final JedisSocketFactory socketFactory;
    private Socket socket;
    private RedisOutputStream outputStream;
    private RedisInputStream inputStream;
    private int infiniteSoTimeout = 0;
    private boolean broken = false;

    public Connection() {
        this("127.0.0.1", 6379);
    }

    public Connection(String host, int port) {
        this(new HostAndPort(host, port));
    }

    public Connection(HostAndPort hostAndPort) {
        this(hostAndPort, (JedisClientConfig)DefaultJedisClientConfig.builder().build());
    }

    public Connection(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(new DefaultJedisSocketFactory(hostAndPort, clientConfig));
        this.infiniteSoTimeout = clientConfig.getBlockingSocketTimeoutMillis();
        this.initializeFromClientConfig(clientConfig);
    }

    public Connection(JedisSocketFactory socketFactory, JedisClientConfig clientConfig) {
        this(socketFactory, clientConfig, null);
    }

    public Connection(JedisSocketFactory socketFactory, JedisClientConfig clientConfig, Pool<Connection> pool) {
        this.socketFactory = socketFactory;
        this.infiniteSoTimeout = clientConfig.getBlockingSocketTimeoutMillis();
        this.initializeFromClientConfig(clientConfig);
        this.memberOf = pool;
    }

    public Connection(JedisSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
        this.memberOf = null;
    }

    public String toString() {
        return "Connection{" + this.socketFactory + "}";
    }

    public void setSoTimeout(int soTimeout) {
        this.socketFactory.setSocketTimeout(soTimeout);
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(soTimeout);
            }
            catch (SocketException ex) {
                this.broken = true;
                throw new JedisConnectionException(ex);
            }
        }
    }

    public void setTimeoutInfinite() {
        try {
            if (!this.isConnected()) {
                this.connect();
            }
            this.socket.setSoTimeout(this.infiniteSoTimeout);
        }
        catch (SocketException ex) {
            this.broken = true;
            throw new JedisConnectionException(ex);
        }
    }

    public void rollbackTimeout() {
        try {
            this.socket.setSoTimeout(this.socketFactory.getSocketTimeout());
        }
        catch (SocketException ex) {
            this.broken = true;
            throw new JedisConnectionException(ex);
        }
    }

    public Object executeCommand(ProtocolCommand cmd) {
        this.sendCommand(cmd);
        return this.getOne();
    }

    public void sendCommand(ProtocolCommand cmd, String ... args) {
        byte[][] bargs = new byte[args.length][];
        for (int i = 0; i < args.length; ++i) {
            bargs[i] = SafeEncoder.encode(args[i]);
        }
        this.sendCommand(cmd, bargs);
    }

    public void sendCommand(ProtocolCommand cmd) {
        this.sendCommand(cmd, EMPTY_ARGS);
    }

    public void sendCommand(ProtocolCommand cmd, Rawable keyword) {
        this.sendCommand(cmd, new byte[][]{keyword.getRaw()});
    }

    public void sendCommand(ProtocolCommand cmd, byte[] ... args) {
        try {
            this.connect();
            Protocol.sendCommand(this.outputStream, cmd, args);
        }
        catch (JedisConnectionException ex) {
            try {
                String errorMessage = Protocol.readErrorLineIfPossible(this.inputStream);
                if (errorMessage != null && errorMessage.length() > 0) {
                    ex = new JedisConnectionException(errorMessage, ex.getCause());
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.broken = true;
            throw ex;
        }
    }

    public Object executeCommand(CommandArguments args) {
        this.sendCommand(args);
        return this.getOne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeCommand(CommandObject<T> commandObject) {
        CommandArguments args = commandObject.getArguments();
        this.sendCommand(args);
        if (!args.isBlocking()) {
            return commandObject.getBuilder().build(this.getOne());
        }
        try {
            this.setTimeoutInfinite();
            T t = commandObject.getBuilder().build(this.getOne());
            return t;
        }
        finally {
            this.rollbackTimeout();
        }
    }

    public void sendCommand(CommandArguments args) {
        try {
            this.connect();
            Protocol.sendCommand(this.outputStream, args);
        }
        catch (JedisConnectionException ex) {
            try {
                String errorMessage = Protocol.readErrorLineIfPossible(this.inputStream);
                if (errorMessage != null && errorMessage.length() > 0) {
                    ex = new JedisConnectionException(errorMessage, ex.getCause());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.broken = true;
            throw ex;
        }
    }

    public void connect() throws JedisConnectionException {
        if (!this.isConnected()) {
            try {
                this.socket = this.socketFactory.createSocket();
                this.outputStream = new RedisOutputStream(this.socket.getOutputStream());
                this.inputStream = new RedisInputStream(this.socket.getInputStream());
            }
            catch (JedisConnectionException jce) {
                this.broken = true;
                throw jce;
            }
            catch (IOException ioe) {
                this.broken = true;
                throw new JedisConnectionException("Failed to create input/output stream", ioe);
            }
            finally {
                if (this.broken) {
                    IOUtils.closeQuietly(this.socket);
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.memberOf != null) {
            if (this.isBroken()) {
                this.memberOf.returnBrokenResource(this);
            } else {
                this.memberOf.returnResource(this);
            }
        } else {
            this.disconnect();
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            try {
                this.outputStream.flush();
                this.socket.close();
            }
            catch (IOException ex) {
                this.broken = true;
                throw new JedisConnectionException(ex);
            }
            finally {
                IOUtils.closeQuietly(this.socket);
            }
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isBound() && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    public String getStatusCodeReply() {
        this.flush();
        byte[] resp = (byte[])this.readProtocolWithCheckingBroken();
        if (null == resp) {
            return null;
        }
        return SafeEncoder.encode(resp);
    }

    public String getBulkReply() {
        byte[] result = this.getBinaryBulkReply();
        if (null != result) {
            return SafeEncoder.encode(result);
        }
        return null;
    }

    public byte[] getBinaryBulkReply() {
        this.flush();
        return (byte[])this.readProtocolWithCheckingBroken();
    }

    public Long getIntegerReply() {
        this.flush();
        return (Long)this.readProtocolWithCheckingBroken();
    }

    public List<String> getMultiBulkReply() {
        return this.getBinaryMultiBulkReply().stream().map(binary -> SafeEncoder.encode(binary)).collect(Collectors.toList());
    }

    public List<byte[]> getBinaryMultiBulkReply() {
        this.flush();
        return (List)this.readProtocolWithCheckingBroken();
    }

    @Deprecated
    public List<Object> getRawObjectMultiBulkReply() {
        return this.getUnflushedObjectMultiBulkReply();
    }

    public List<Object> getUnflushedObjectMultiBulkReply() {
        return (List)this.readProtocolWithCheckingBroken();
    }

    public List<Object> getObjectMultiBulkReply() {
        this.flush();
        return this.getUnflushedObjectMultiBulkReply();
    }

    public List<Long> getIntegerMultiBulkReply() {
        this.flush();
        return (List)this.readProtocolWithCheckingBroken();
    }

    public Object getOne() {
        this.flush();
        return this.readProtocolWithCheckingBroken();
    }

    public boolean isBroken() {
        return this.broken;
    }

    protected void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException ex) {
            this.broken = true;
            throw new JedisConnectionException(ex);
        }
    }

    protected Object readProtocolWithCheckingBroken() {
        if (this.broken) {
            throw new JedisConnectionException("Attempting to read from a broken connection");
        }
        try {
            return Protocol.read(this.inputStream);
        }
        catch (JedisConnectionException exc) {
            this.broken = true;
            throw exc;
        }
    }

    public List<Object> getMany(int count) {
        this.flush();
        ArrayList<Object> responses = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            try {
                responses.add(this.readProtocolWithCheckingBroken());
                continue;
            }
            catch (JedisDataException e) {
                responses.add(e);
            }
        }
        return responses;
    }

    private void initializeFromClientConfig(JedisClientConfig config) {
        try {
            String clientName;
            int dbIndex;
            this.connect();
            String password = config.getPassword();
            if (password != null) {
                String user = config.getUser();
                if (user != null) {
                    this.auth(user, password);
                } else {
                    this.auth(password);
                }
            }
            if ((dbIndex = config.getDatabase()) > 0) {
                this.select(dbIndex);
            }
            if ((clientName = config.getClientName()) != null) {
                this.clientSetname(clientName);
            }
        }
        catch (JedisException je) {
            try {
                if (this.isConnected()) {
                    this.quit();
                }
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw je;
        }
    }

    public String quit() {
        this.sendCommand(Protocol.Command.QUIT);
        String quitReturn = this.getStatusCodeReply();
        this.disconnect();
        return quitReturn;
    }

    private String auth(String password) {
        this.sendCommand((ProtocolCommand)Protocol.Command.AUTH, password);
        return this.getStatusCodeReply();
    }

    private String auth(String user, String password) {
        this.sendCommand((ProtocolCommand)Protocol.Command.AUTH, user, password);
        return this.getStatusCodeReply();
    }

    public String select(int index) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SELECT, new byte[][]{Protocol.toByteArray(index)});
        return this.getStatusCodeReply();
    }

    private String clientSetname(String name) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.SETNAME.name(), name);
        return this.getStatusCodeReply();
    }

    public void ping() {
        this.sendCommand(Protocol.Command.PING);
        String status = this.getStatusCodeReply();
        if (!"PONG".equals(status)) {
            throw new JedisException(status);
        }
    }
}

