/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.HostAndPortMapper;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.util.IOUtils;

public class DefaultJedisSocketFactory
implements JedisSocketFactory {
    protected static final HostAndPort DEFAULT_HOST_AND_PORT = new HostAndPort("127.0.0.1", 6379);
    private volatile HostAndPort hostAndPort = DEFAULT_HOST_AND_PORT;
    private int connectionTimeout = 2000;
    private int socketTimeout = 2000;
    private boolean ssl = false;
    private SSLSocketFactory sslSocketFactory = null;
    private SSLParameters sslParameters = null;
    private HostnameVerifier hostnameVerifier = null;
    private HostAndPortMapper hostAndPortMapper = null;

    public DefaultJedisSocketFactory() {
    }

    public DefaultJedisSocketFactory(HostAndPort hostAndPort) {
        this(hostAndPort, null);
    }

    public DefaultJedisSocketFactory(JedisClientConfig config) {
        this(null, config);
    }

    @Deprecated
    public DefaultJedisSocketFactory(String host, int port, int connectionTimeout, int socketTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this.hostAndPort = new HostAndPort(host, port);
        this.connectionTimeout = connectionTimeout;
        this.socketTimeout = socketTimeout;
        this.ssl = ssl;
        this.sslSocketFactory = sslSocketFactory;
        this.sslParameters = sslParameters;
        this.hostnameVerifier = hostnameVerifier;
    }

    public DefaultJedisSocketFactory(HostAndPort hostAndPort, JedisClientConfig config) {
        if (hostAndPort != null) {
            this.hostAndPort = hostAndPort;
        }
        if (config != null) {
            this.connectionTimeout = config.getConnectionTimeoutMillis();
            this.socketTimeout = config.getSocketTimeoutMillis();
            this.ssl = config.isSsl();
            this.sslSocketFactory = config.getSslSocketFactory();
            this.sslParameters = config.getSslParameters();
            this.hostnameVerifier = config.getHostnameVerifier();
            this.hostAndPortMapper = config.getHostAndPortMapper();
        }
    }

    @Override
    public Socket createSocket() throws JedisConnectionException {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setReuseAddress(true);
            socket.setKeepAlive(true);
            socket.setTcpNoDelay(true);
            socket.setSoLinger(true, 0);
            HostAndPort _hostAndPort = this.getSocketHostAndPort();
            socket.connect(new InetSocketAddress(_hostAndPort.getHost(), _hostAndPort.getPort()), this.connectionTimeout);
            socket.setSoTimeout(this.socketTimeout);
            if (this.ssl) {
                SSLSocketFactory _sslSocketFactory = this.sslSocketFactory;
                if (null == _sslSocketFactory) {
                    _sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                }
                socket = _sslSocketFactory.createSocket(socket, _hostAndPort.getHost(), _hostAndPort.getPort(), true);
                if (null != this.sslParameters) {
                    ((SSLSocket)socket).setSSLParameters(this.sslParameters);
                }
                if (null != this.hostnameVerifier && !this.hostnameVerifier.verify(_hostAndPort.getHost(), ((SSLSocket)socket).getSession())) {
                    String message = String.format("The connection to '%s' failed ssl/tls hostname verification.", _hostAndPort.getHost());
                    throw new JedisConnectionException(message);
                }
            }
            return socket;
        }
        catch (IOException ex) {
            IOUtils.closeQuietly(socket);
            throw new JedisConnectionException("Failed to create socket.", ex);
        }
    }

    public void updateHostAndPort(HostAndPort hostAndPort) {
        this.hostAndPort = hostAndPort;
    }

    protected HostAndPort getSocketHostAndPort() {
        HostAndPort mapped;
        HostAndPortMapper mapper = this.hostAndPortMapper;
        HostAndPort hap = this.hostAndPort;
        if (mapper != null && (mapped = mapper.getHostAndPort(hap)) != null) {
            return mapped;
        }
        return hap;
    }

    @Override
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public String toString() {
        return "DefaultJedisSocketFactory{" + this.hostAndPort.toString() + "}";
    }
}

