/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.util.List;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Queable;
import redis.clients.jedis.Response;

public class PipelineBase
extends Queable
implements Closeable {
    protected final Connection connection;

    public PipelineBase(Connection connection) {
        this.connection = connection;
    }

    public final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        this.connection.sendCommand(commandObject.getArguments());
        return this.enqueResponse(commandObject.getBuilder());
    }

    @Override
    public void close() {
        this.sync();
    }

    public final void sync() {
        List<Object> unformatted = this.connection.getMany(this.getPipelinedResponseLength());
        for (Object o : unformatted) {
            this.generateResponse(o);
        }
    }

    @Deprecated
    public final boolean hasPipelinedResponse() {
        return this.getPipelinedResponseLength() > 0;
    }
}

