/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.util.List;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Queable;
import redis.clients.jedis.Response;

public class PipelinedTransactionBase
extends Queable
implements Closeable {
    private boolean inTransaction = true;
    protected final Connection connection;

    public PipelinedTransactionBase(Connection connection) {
        this.connection = connection;
        this.connection.sendCommand(Protocol.Command.MULTI);
    }

    protected final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        this.connection.sendCommand(commandObject.getArguments());
        return this.enqueResponse(commandObject.getBuilder());
    }

    @Override
    public void close() {
        this.clear();
    }

    public void clear() {
        if (this.inTransaction) {
            this.discard();
        }
    }

    public final void exec() {
        this.connection.getMany(1 + this.getPipelinedResponseLength());
        this.connection.sendCommand(Protocol.Command.EXEC);
        this.inTransaction = false;
        List<Object> unformatted = this.connection.getObjectMultiBulkReply();
        unformatted.stream().forEachOrdered(u -> this.generateResponse(u));
    }

    public void discard() {
        this.connection.getMany(1 + this.getPipelinedResponseLength());
        this.connection.sendCommand(Protocol.Command.DISCARD);
        this.connection.getStatusCodeReply();
        this.inTransaction = false;
        this.clean();
    }
}

