/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Set;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.ClusterCommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.RedisCommandObjects;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.search.IndexOptions;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.Schema;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.util.JedisClusterHashTag;

public class RedisClusterCommandObjects
extends RedisCommandObjects {
    private static final String KEYS_PATTERN_MESSAGE = "Cluster mode only supports KEYS command with pattern containing hash-tag ( curly-brackets enclosed string )";
    private static final String SCAN_PATTERN_MESSAGE = "Cluster mode only supports SCAN command with MATCH pattern containing hash-tag ( curly-brackets enclosed string )";
    boolean searchLite = false;

    @Override
    protected ClusterCommandArguments commandArguments(ProtocolCommand command) {
        return new ClusterCommandArguments(command);
    }

    @Override
    public final CommandObject<Set<String>> keys(String pattern) {
        if (!JedisClusterHashTag.isClusterCompliantMatchPattern(pattern)) {
            throw new IllegalArgumentException(KEYS_PATTERN_MESSAGE);
        }
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.KEYS).key(pattern).processKey(pattern), BuilderFactory.STRING_SET);
    }

    @Override
    public final CommandObject<Set<byte[]>> keys(byte[] pattern) {
        if (!JedisClusterHashTag.isClusterCompliantMatchPattern(pattern)) {
            throw new IllegalArgumentException(KEYS_PATTERN_MESSAGE);
        }
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.KEYS).key(pattern).processKey(pattern), BuilderFactory.BINARY_SET);
    }

    @Override
    public final CommandObject<ScanResult<String>> scan(String cursor) {
        throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
    }

    @Override
    public final CommandObject<ScanResult<String>> scan(String cursor, ScanParams params) {
        String match = params.match();
        if (match == null || !JedisClusterHashTag.isClusterCompliantMatchPattern(match)) {
            throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
        }
        return new CommandObject<ScanResult<String>>(this.commandArguments(Protocol.Command.SCAN).addParams(params).processKey(match), BuilderFactory.SCAN_RESPONSE);
    }

    @Override
    public final CommandObject<ScanResult<String>> scan(String cursor, ScanParams params, String type) {
        String match = params.match();
        if (match == null || !JedisClusterHashTag.isClusterCompliantMatchPattern(match)) {
            throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
        }
        return new CommandObject<ScanResult<String>>(this.commandArguments(Protocol.Command.SCAN).addParams(params).processKey(match).add(Protocol.Keyword.TYPE).add(type), BuilderFactory.SCAN_RESPONSE);
    }

    @Override
    public final CommandObject<ScanResult<byte[]>> scan(byte[] cursor) {
        throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
    }

    @Override
    public final CommandObject<ScanResult<byte[]>> scan(byte[] cursor, ScanParams params) {
        byte[] match = params.binaryMatch();
        if (match == null || !JedisClusterHashTag.isClusterCompliantMatchPattern(match)) {
            throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
        }
        return new CommandObject<ScanResult<byte[]>>(this.commandArguments(Protocol.Command.SCAN).addParams(params).processKey(match), BuilderFactory.SCAN_BINARY_RESPONSE);
    }

    @Override
    public final CommandObject<ScanResult<byte[]>> scan(byte[] cursor, ScanParams params, byte[] type) {
        byte[] match = params.binaryMatch();
        if (match == null || !JedisClusterHashTag.isClusterCompliantMatchPattern(match)) {
            throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
        }
        return new CommandObject<ScanResult<byte[]>>(this.commandArguments(Protocol.Command.SCAN).addParams(params).processKey(match).add(Protocol.Keyword.TYPE).add(type), BuilderFactory.SCAN_BINARY_RESPONSE);
    }

    private <T> CommandObject<T> processSearchCommand(String indexName, CommandObject<T> command) {
        if (this.searchLite) {
            command.getArguments().processKey(indexName);
        }
        return command;
    }

    private <T> CommandObject<T> processSearchCommand(byte[] indexName, CommandObject<T> command) {
        if (this.searchLite) {
            command.getArguments().processKey(indexName);
        }
        return command;
    }

    @Override
    public CommandObject<String> ftCreate(String indexName, IndexOptions indexOptions, Schema schema) {
        return this.processSearchCommand(indexName, super.ftCreate(indexName, indexOptions, schema));
    }

    @Override
    public CommandObject<SearchResult> ftSearch(String indexName, Query query) {
        return this.processSearchCommand(indexName, super.ftSearch(indexName, query));
    }

    @Override
    public CommandObject<SearchResult> ftSearch(byte[] indexName, Query query) {
        return this.processSearchCommand(indexName, super.ftSearch(indexName, query));
    }
}

