/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.util.SafeEncoder;

public class FieldName
implements IParams {
    private static final byte[] AS = SafeEncoder.encode("AS");
    private final String name;
    private String attribute;

    public FieldName(String name) {
        this(name, null);
    }

    public FieldName(String name, String attribute) {
        this.name = name;
        this.attribute = attribute;
    }

    public int addCommandArguments(CommandArguments args) {
        args.add(SafeEncoder.encode(this.name));
        if (this.attribute == null) {
            return 1;
        }
        args.add(AS);
        args.add(SafeEncoder.encode(this.attribute));
        return 3;
    }

    @Override
    public void addParams(CommandArguments args) {
        this.addCommandArguments(args);
    }

    String getName() {
        return this.name;
    }

    public String toString() {
        return this.attribute == null ? this.name : this.name + " AS " + this.attribute;
    }

    public static FieldName of(String name) {
        return new FieldName(name);
    }

    public FieldName as(String attribute) {
        this.attribute = attribute;
        return this;
    }

    public static FieldName[] convert(String ... names) {
        if (names == null) {
            return null;
        }
        FieldName[] fields = new FieldName[names.length];
        for (int i = 0; i < names.length; ++i) {
            fields[i] = FieldName.of(names[i]);
        }
        return fields;
    }
}

