/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Queable;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisDataException;

public class PipelinedTransactionBase
extends Queable
implements Closeable {
    private boolean inTransaction = true;
    protected final Connection connection;

    public PipelinedTransactionBase(Connection connection) {
        this.connection = connection;
        this.connection.sendCommand(Protocol.Command.MULTI);
    }

    protected final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        this.connection.sendCommand(commandObject.getArguments());
        return this.enqueResponse(commandObject.getBuilder());
    }

    @Override
    public void close() {
        this.clear();
    }

    public void clear() {
        if (this.inTransaction) {
            this.discard();
        }
    }

    public Response<String> unwatch() {
        return this.appendCommand(new CommandObject<String>(new CommandArguments(Protocol.Command.UNWATCH), BuilderFactory.STRING));
    }

    public List<Object> exec() {
        if (!this.inTransaction) {
            throw new IllegalStateException("EXEC without MULTI");
        }
        this.connection.getMany(1 + this.getPipelinedResponseLength());
        this.connection.sendCommand(Protocol.Command.EXEC);
        this.inTransaction = false;
        List<Object> unformatted = this.connection.getObjectMultiBulkReply();
        if (unformatted == null) {
            return null;
        }
        ArrayList<Object> formatted = new ArrayList<Object>(unformatted.size());
        for (Object o : unformatted) {
            try {
                formatted.add(this.generateResponse(o).get());
            }
            catch (JedisDataException e) {
                formatted.add(e);
            }
        }
        return formatted;
    }

    public String discard() {
        if (!this.inTransaction) {
            throw new IllegalStateException("DISCARD without MULTI");
        }
        this.connection.getMany(1 + this.getPipelinedResponseLength());
        this.connection.sendCommand(Protocol.Command.DISCARD);
        String status = this.connection.getStatusCodeReply();
        this.inTransaction = false;
        this.clean();
        return status;
    }
}

