/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Connection;
import redis.clients.jedis.JedisCommandExecutor;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.exceptions.JedisAskDataException;
import redis.clients.jedis.exceptions.JedisClusterOperationException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.exceptions.JedisRedirectionException;
import redis.clients.jedis.providers.JedisClusterConnectionProvider;

public class RetryableClusterCommandExecutor
implements JedisCommandExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RetryableClusterCommandExecutor.class);
    protected final JedisClusterConnectionProvider provider;
    protected final int maxAttempts;
    protected final Duration maxTotalRetriesDuration;

    public RetryableClusterCommandExecutor(JedisClusterConnectionProvider provider, int maxAttempts, Duration maxTotalRetriesDuration) {
        this.provider = provider;
        this.maxAttempts = maxAttempts;
        this.maxTotalRetriesDuration = maxTotalRetriesDuration;
    }

    @Override
    public void close() {
        this.provider.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T executeCommand(CommandObject<T> commandObject) {
        Instant deadline = Instant.now().plus(this.maxTotalRetriesDuration);
        JedisRedirectionException redirect = null;
        int consecutiveConnectionFailures = 0;
        JedisException lastException = null;
        for (int attemptsLeft = this.maxAttempts; attemptsLeft > 0; --attemptsLeft) {
            try (Connection connection = null;){
                if (redirect != null) {
                    connection = this.provider.getConnection(redirect.getTargetNode());
                    if (redirect instanceof JedisAskDataException) {
                        connection.executeCommand(Protocol.Command.ASKING);
                    }
                } else {
                    connection = this.provider.getConnection(commandObject.getArguments());
                }
                T t = connection.executeCommand(commandObject);
                return t;
            }
            if (!Instant.now().isAfter(deadline)) continue;
            throw new JedisClusterOperationException("Cluster retry deadline exceeded.");
        }
        JedisClusterOperationException maxAttemptsException = new JedisClusterOperationException("No more cluster attempts left.");
        maxAttemptsException.addSuppressed(lastException);
        throw maxAttemptsException;
    }

    private boolean handleConnectionProblem(int attemptsLeft, int consecutiveConnectionFailures, Instant doneDeadline) {
        if (this.maxAttempts < 3) {
            if (attemptsLeft == 0) {
                this.provider.renewSlotCache();
                return true;
            }
            return false;
        }
        if (consecutiveConnectionFailures < 2) {
            return false;
        }
        this.sleep(RetryableClusterCommandExecutor.getBackoffSleepMillis(attemptsLeft, doneDeadline));
        this.provider.renewSlotCache();
        return true;
    }

    private static long getBackoffSleepMillis(int attemptsLeft, Instant deadline) {
        if (attemptsLeft <= 0) {
            return 0L;
        }
        long millisLeft = Duration.between(Instant.now(), deadline).toMillis();
        if (millisLeft < 0L) {
            throw new JedisClusterOperationException("Cluster retry deadline exceeded.");
        }
        return millisLeft / (long)(attemptsLeft * (attemptsLeft + 1));
    }

    protected void sleep(long sleepMillis) {
        try {
            TimeUnit.MILLISECONDS.sleep(sleepMillis);
        }
        catch (InterruptedException e) {
            throw new JedisClusterOperationException(e);
        }
    }
}

