/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.commands;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.Response;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.params.XAutoClaimParams;
import redis.clients.jedis.params.XClaimParams;
import redis.clients.jedis.params.XPendingParams;
import redis.clients.jedis.params.XReadGroupParams;
import redis.clients.jedis.params.XReadParams;
import redis.clients.jedis.params.XTrimParams;
import redis.clients.jedis.stream.StreamConsumersInfo;
import redis.clients.jedis.stream.StreamEntry;
import redis.clients.jedis.stream.StreamEntryID;
import redis.clients.jedis.stream.StreamGroupInfo;
import redis.clients.jedis.stream.StreamInfo;
import redis.clients.jedis.stream.StreamPendingEntry;
import redis.clients.jedis.stream.StreamPendingSummary;

public interface StreamPipelineCommands {
    public Response<StreamEntryID> xadd(String var1, StreamEntryID var2, Map<String, String> var3);

    default public Response<StreamEntryID> xadd(String key, Map<String, String> hash, XAddParams params) {
        return this.xadd_v2(key, params, hash);
    }

    public Response<StreamEntryID> xadd_v2(String var1, XAddParams var2, Map<String, String> var3);

    public Response<Long> xlen(String var1);

    public Response<List<StreamEntry>> xrange(String var1, StreamEntryID var2, StreamEntryID var3);

    public Response<List<StreamEntry>> xrange(String var1, StreamEntryID var2, StreamEntryID var3, int var4);

    public Response<List<StreamEntry>> xrevrange(String var1, StreamEntryID var2, StreamEntryID var3);

    public Response<List<StreamEntry>> xrevrange(String var1, StreamEntryID var2, StreamEntryID var3, int var4);

    public Response<Long> xack(String var1, String var2, StreamEntryID ... var3);

    public Response<String> xgroupCreate(String var1, String var2, StreamEntryID var3, boolean var4);

    public Response<String> xgroupSetID(String var1, String var2, StreamEntryID var3);

    public Response<Long> xgroupDestroy(String var1, String var2);

    public Response<Long> xgroupDelConsumer(String var1, String var2, String var3);

    public Response<StreamPendingSummary> xpending(String var1, String var2);

    public Response<List<StreamPendingEntry>> xpending(String var1, String var2, StreamEntryID var3, StreamEntryID var4, int var5, String var6);

    public Response<List<StreamPendingEntry>> xpending(String var1, String var2, XPendingParams var3);

    public Response<Long> xdel(String var1, StreamEntryID ... var2);

    public Response<Long> xtrim(String var1, long var2, boolean var4);

    public Response<Long> xtrim(String var1, XTrimParams var2);

    public Response<List<StreamEntry>> xclaim(String var1, String var2, String var3, long var4, XClaimParams var6, StreamEntryID ... var7);

    public Response<List<StreamEntryID>> xclaimJustId(String var1, String var2, String var3, long var4, XClaimParams var6, StreamEntryID ... var7);

    public Response<Map.Entry<StreamEntryID, List<StreamEntry>>> xautoclaim(String var1, String var2, String var3, long var4, StreamEntryID var6, XAutoClaimParams var7);

    public Response<Map.Entry<StreamEntryID, List<StreamEntryID>>> xautoclaimJustId(String var1, String var2, String var3, long var4, StreamEntryID var6, XAutoClaimParams var7);

    public Response<StreamInfo> xinfoStream(String var1);

    public Response<List<StreamGroupInfo>> xinfoGroup(String var1);

    public Response<List<StreamConsumersInfo>> xinfoConsumers(String var1, String var2);

    public Response<List<Map.Entry<String, List<StreamEntry>>>> xread(XReadParams var1, Map<String, StreamEntryID> var2);

    default public Response<List<Map.Entry<String, List<StreamEntry>>>> xreadGroup(String groupname, String consumer, int count, long block, boolean noAck, Map.Entry<String, StreamEntryID> ... streams) {
        if (block > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        XReadGroupParams params = XReadGroupParams.xReadGroupParams();
        if (count > 0) {
            params.count(count);
        }
        if (block > 0L) {
            params.block((int)block);
        }
        if (noAck) {
            params.noAck();
        }
        LinkedHashMap<String, StreamEntryID> streamMap = new LinkedHashMap<String, StreamEntryID>(streams.length);
        for (Map.Entry<String, StreamEntryID> stream : streams) {
            streamMap.put(stream.getKey(), stream.getValue());
        }
        return this.xreadGroup(groupname, consumer, params, streamMap);
    }

    public Response<List<Map.Entry<String, List<StreamEntry>>>> xreadGroup(String var1, String var2, XReadGroupParams var3, Map<String, StreamEntryID> var4);
}

