/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search.schemafields;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.search.FieldName;
import redis.clients.jedis.search.SearchProtocol;
import redis.clients.jedis.search.schemafields.SchemaField;
import redis.clients.jedis.util.SafeEncoder;

public class TagField
extends SchemaField {
    private boolean sortable;
    private boolean sortableUNF;
    private boolean noIndex;
    private byte[] separator;
    private boolean caseSensitive;
    private boolean withSuffixTrie;

    public TagField(String fieldName) {
        super(fieldName);
    }

    public TagField(FieldName fieldName) {
        super(fieldName);
    }

    public static TagField of(String fieldName) {
        return new TagField(fieldName);
    }

    public static TagField of(FieldName fieldName) {
        return new TagField(fieldName);
    }

    @Override
    public TagField as(String attribute) {
        super.as(attribute);
        return this;
    }

    public TagField sortable() {
        this.sortable = true;
        return this;
    }

    public TagField sortableUNF() {
        this.sortableUNF = true;
        return this;
    }

    public TagField sortableUnNormalizedForm() {
        return this.sortableUNF();
    }

    public TagField noIndex() {
        this.noIndex = true;
        return this;
    }

    public TagField separator(char separator) {
        this.separator = separator < '\u0080' ? new byte[]{(byte)separator} : SafeEncoder.encode(String.valueOf(separator));
        return this;
    }

    public TagField caseSensitive() {
        this.caseSensitive = true;
        return this;
    }

    public TagField withSuffixTrie() {
        this.withSuffixTrie = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        args.addParams(this.fieldName);
        args.add(SearchProtocol.SearchKeyword.TAG);
        if (this.separator != null) {
            args.add(SearchProtocol.SearchKeyword.SEPARATOR).add(this.separator);
        }
        if (this.sortableUNF) {
            args.add(SearchProtocol.SearchKeyword.SORTABLE).add(SearchProtocol.SearchKeyword.UNF);
        } else if (this.sortable) {
            args.add(SearchProtocol.SearchKeyword.SORTABLE);
        }
        if (this.noIndex) {
            args.add(SearchProtocol.SearchKeyword.NOINDEX);
        }
        if (this.caseSensitive) {
            args.add(SearchProtocol.SearchKeyword.CASESENSITIVE);
        }
        if (this.withSuffixTrie) {
            args.add(SearchProtocol.SearchKeyword.WITHSUFFIXTRIE);
        }
    }
}

