/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search.aggr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.search.aggr.Row;
import redis.clients.jedis.util.SafeEncoder;

public class AggregationResult {
    private final long totalResults;
    private final List<Map<String, Object>> results;
    private long cursorId = -1L;

    public AggregationResult(Object resp, long cursorId) {
        this(resp);
        this.cursorId = cursorId;
    }

    public AggregationResult(Object resp) {
        List list = (List)SafeEncoder.encodeObject(resp);
        this.totalResults = (Long)list.get(0);
        this.results = new ArrayList<Map<String, Object>>(list.size() - 1);
        for (int i = 1; i < list.size(); ++i) {
            List mapList = (List)list.get(i);
            HashMap map = new HashMap(mapList.size() / 2, 1.0f);
            for (int j = 0; j < mapList.size(); j += 2) {
                Object r = mapList.get(j);
                if (r instanceof JedisDataException) {
                    throw (JedisDataException)r;
                }
                map.put((String)r, mapList.get(j + 1));
            }
            this.results.add(map);
        }
    }

    public long getTotalResults() {
        return this.totalResults;
    }

    public List<Map<String, Object>> getResults() {
        return this.results;
    }

    public List<Row> getRows() {
        return this.results.stream().map(Row::new).collect(Collectors.toList());
    }

    public Row getRow(int index) {
        return new Row(this.results.get(index));
    }

    public long getCursorId() {
        return this.cursorId;
    }
}

