/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.CommandObjects;
import redis.clients.jedis.Connection;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.util.IOUtils;

public abstract class MultiNodePipelineBase
extends PipelineBase {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static volatile int MULTI_NODE_PIPELINE_SYNC_WORKERS = 3;
    private final Map<HostAndPort, Queue<Response<?>>> pipelinedResponses = new LinkedHashMap();
    private final Map<HostAndPort, Connection> connections = new LinkedHashMap<HostAndPort, Connection>();
    private volatile boolean syncing = false;

    public MultiNodePipelineBase(CommandObjects commandObjects) {
        super(commandObjects);
    }

    protected abstract HostAndPort getNodeKey(CommandArguments var1);

    protected abstract Connection getConnection(HostAndPort var1);

    @Override
    protected final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        Connection connection;
        Queue<Response<?>> queue;
        HostAndPort nodeKey = this.getNodeKey(commandObject.getArguments());
        if (this.pipelinedResponses.containsKey(nodeKey)) {
            queue = this.pipelinedResponses.get(nodeKey);
            connection = this.connections.get(nodeKey);
        } else {
            Connection newOne = this.getConnection(nodeKey);
            this.connections.putIfAbsent(nodeKey, newOne);
            connection = this.connections.get(nodeKey);
            if (connection != newOne) {
                this.log.debug("Duplicate connection to {}, closing it.", (Object)nodeKey);
                IOUtils.closeQuietly(newOne);
            }
            this.pipelinedResponses.putIfAbsent(nodeKey, new LinkedList());
            queue = this.pipelinedResponses.get(nodeKey);
        }
        connection.sendCommand(commandObject.getArguments());
        Response<T> response = new Response<T>(commandObject.getBuilder());
        queue.add(response);
        return response;
    }

    @Override
    public void close() {
        try {
            this.sync();
        }
        finally {
            this.connections.values().forEach(IOUtils::closeQuietly);
        }
    }

    @Override
    public final void sync() {
        if (this.syncing) {
            return;
        }
        this.syncing = true;
        ExecutorService executorService = Executors.newFixedThreadPool(MULTI_NODE_PIPELINE_SYNC_WORKERS);
        CountDownLatch countDownLatch = new CountDownLatch(this.pipelinedResponses.size());
        Iterator<Map.Entry<HostAndPort, Queue<Response<?>>>> pipelinedResponsesIterator = this.pipelinedResponses.entrySet().iterator();
        while (pipelinedResponsesIterator.hasNext()) {
            Map.Entry<HostAndPort, Queue<Response<?>>> entry = pipelinedResponsesIterator.next();
            HostAndPort nodeKey = entry.getKey();
            Queue<Response<?>> queue = entry.getValue();
            Connection connection = this.connections.get(nodeKey);
            executorService.submit(() -> {
                try {
                    List<Object> unformatted = connection.getMany(queue.size());
                    for (Object o : unformatted) {
                        ((Response)queue.poll()).set(o);
                    }
                }
                catch (JedisConnectionException jce) {
                    this.log.error("Error with connection to " + nodeKey, (Throwable)jce);
                    pipelinedResponsesIterator.remove();
                    this.connections.remove(nodeKey);
                    IOUtils.closeQuietly(connection);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            this.log.error("Thread is interrupted during sync.", (Throwable)e);
        }
        executorService.shutdownNow();
        this.syncing = false;
    }

    @Deprecated
    public Response<Long> waitReplicas(int replicas, long timeout) {
        return this.appendCommand(this.commandObjects.waitReplicas(replicas, timeout));
    }
}

