/*
 * Decompiled with CFR 0.152.
 */
package ren.yale.java.words.sensitive;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ren.yale.java.words.excep.NotInitException;
import ren.yale.java.words.sensitive.SensitiveMatchType;
import ren.yale.java.words.sensitive.SensitiveResult;
import ren.yale.java.words.sensitive.SensitiveWord;

public class SensitiveWordDFA
implements SensitiveWord {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static HashMap sensitiveWordMap;
    private static final String END_KEY = "en";
    private static final String DICT = "keyword.txt";

    @Override
    public void init(InputStream inputStream) {
        try {
            HashSet<String> words = new HashSet<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                words.add(line.trim());
            }
            br.close();
            this.init(words);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() {
        this.init(this.getClass().getResourceAsStream("/keyword.txt"));
    }

    private void checkInit() throws NotInitException {
        if (sensitiveWordMap == null) {
            throw new NotInitException("not init SensitiveWord");
        }
    }

    @Override
    public void init(Set<String> sensitiveWordSet) {
        sensitiveWordMap = new HashMap(this.getInitCapacity(sensitiveWordSet), 0.75f);
        for (String v : sensitiveWordSet) {
            HashMap<Character, HashMap<String, Boolean>> charNode = null;
            HashMap<Character, HashMap<String, Boolean>> sm = sensitiveWordMap;
            for (int i = 0; i < v.length(); ++i) {
                char ch = v.charAt(i);
                charNode = (HashMap<Character, HashMap<String, Boolean>>)sm.get(Character.valueOf(ch));
                if (charNode == null) {
                    charNode = new HashMap<Character, HashMap<String, Boolean>>();
                    sm.put(Character.valueOf(ch), charNode);
                    charNode.put((Character)((Object)END_KEY), (HashMap<String, Boolean>)(i == v.length() - 1 ? 1 : 0));
                } else if (!this.isEnd(charNode)) {
                    charNode.put((Character)((Object)END_KEY), (HashMap<String, Boolean>)(i == v.length() - 1 ? 1 : 0));
                }
                sm = charNode;
            }
        }
    }

    private int getInitCapacity(Set<String> sensitiveWordSet) {
        HashSet<Character> setChar = new HashSet<Character>();
        for (String v : sensitiveWordSet) {
            setChar.add(Character.valueOf(v.charAt(0)));
        }
        float ft = (float)setChar.size() / 0.75f + 1.0f;
        return (int)ft;
    }

    @Override
    public boolean contains(String txt, SensitiveMatchType matchType) throws NotInitException {
        this.checkInit();
        for (int i = 0; i < txt.length(); ++i) {
            int index = this.check(txt, i, matchType);
            if (index == -1 || index - i <= 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(String txt) throws NotInitException {
        return this.contains(txt, SensitiveMatchType.MaxMath);
    }

    private boolean isEnd(Map mp) {
        Object find = mp.get(END_KEY);
        if (find == null) {
            return false;
        }
        return (Boolean)find;
    }

    private int check(String txt, int startIndex, SensitiveMatchType matchType) throws NotInitException {
        Map sm;
        Map tmp = sensitiveWordMap;
        int index = -1;
        for (int i = startIndex; i < txt.length() && (sm = (Map)tmp.get(Character.valueOf(txt.charAt(i)))) != null; ++i) {
            index = i;
            tmp = sm;
            if (!this.isEnd(tmp) || matchType != SensitiveMatchType.MinMatch) continue;
            return index;
        }
        return this.isEnd(tmp) ? index : -1;
    }

    @Override
    public List<String> getSensitiveWord(String txt, SensitiveMatchType matchType) throws NotInitException {
        this.checkInit();
        ArrayList<String> findWords = new ArrayList<String>();
        for (int i = 0; i < txt.length(); ++i) {
            int index = this.check(txt, i, matchType);
            if (index != -1 && index - i >= 1 && !findWords.contains(txt.substring(i, index + 1))) {
                findWords.add(txt.substring(i, index + 1));
            }
            if (index == -1 || index == i) continue;
            i = index;
        }
        Collections.sort(findWords, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        return findWords;
    }

    @Override
    public List<String> getSensitiveWord(String txt) throws NotInitException {
        return this.getSensitiveWord(txt, SensitiveMatchType.MaxMath);
    }

    private String getRepeatChars(char replaceStr, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(replaceStr);
        }
        return sb.toString();
    }

    @Override
    public SensitiveResult replaceSensitiveWord(String txt, char replaceStr, SensitiveMatchType matchType) throws NotInitException {
        this.checkInit();
        List<String> findWords = this.getSensitiveWord(txt, matchType);
        for (String v : findWords) {
            txt = txt.replaceAll(v, this.getRepeatChars(replaceStr, v.length()));
        }
        SensitiveResult sensitiveResult = new SensitiveResult();
        sensitiveResult.setHaveSensitiveWord(findWords.size() > 0);
        sensitiveResult.setSensitiveWords(findWords);
        sensitiveResult.setAntiSensitive(txt);
        return sensitiveResult;
    }

    @Override
    public SensitiveResult replaceSensitiveWord(String txt, char replaceStr) throws NotInitException {
        return this.replaceSensitiveWord(txt, replaceStr, SensitiveMatchType.MaxMath);
    }
}

