/*
 * Decompiled with CFR 0.152.
 */
package report.donut.adapters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import report.donut.gherkin.model.Element;
import report.donut.gherkin.model.Feature;
import report.donut.gherkin.model.Match;
import report.donut.gherkin.model.Result;
import report.donut.gherkin.model.Step;
import report.donut.gherkin.model.Tag;
import report.donut.junit.model.Failure;
import report.donut.junit.model.Testcase;
import report.donut.junit.model.Testsuite;

public class JUnitAdapter {
    private static final String PASSED = "passed";
    private static final String FAILED = "failed";
    static final String UNIT_TEST_TYPE = "unit-test";
    static final String UNIT_TEST_KEYWORD = "Unit Test";

    public List<Feature> transform(List<Testsuite> testsuites) throws Exception {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Testsuite testsuite : testsuites) {
            features.add(this.makeFeature(testsuite));
        }
        return features;
    }

    private Feature makeFeature(Testsuite testsuite) throws Exception {
        Feature feature = new Feature();
        feature.setName(StringUtils.defaultString((String)testsuite.getName(), (String)"Without feature"));
        feature.setDescription("");
        feature.setId(StringUtils.defaultString((String)testsuite.getId(), (String)""));
        feature.setKeyword("Feature");
        feature.setLine(0);
        feature.setTags(Collections.singletonList(new Tag("@complete", 0)));
        feature.setUri("Test URI");
        feature.setElements(this.makeElements(testsuite.getTestcase()));
        return feature;
    }

    List<Element> makeElements(List<Testcase> testCases) throws Exception {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Testcase testCase : testCases) {
            Element element = new Element();
            element.setName(testCase.getName());
            element.setDescription("");
            element.setLine(0);
            element.setKeyword(UNIT_TEST_KEYWORD);
            element.setId(testCase.toString());
            element.setSteps(this.makeSteps(testCase));
            element.setType(UNIT_TEST_TYPE);
            elements.add(element);
        }
        if (elements.isEmpty()) {
            throw new Exception("The test suite doesn't have any test cases.");
        }
        return elements;
    }

    private List<Step> makeSteps(Testcase testCase) throws Exception {
        Step step = new Step();
        long duration = (long)(Double.valueOf(testCase.getTime()) * 1000.0);
        String status = this.makeStatus(testCase.getFailure());
        if (status.equals(PASSED)) {
            step.setResult(new Result(PASSED, duration, null));
        } else {
            step.setResult(new Result(FAILED, duration, this.makeErrorMessage(testCase.getFailure())));
        }
        step.setKeyword("");
        step.setLine(0);
        step.setName(testCase.getName());
        step.setMatch(new Match(testCase.getClassname()));
        return Collections.singletonList(step);
    }

    private String makeErrorMessage(List<Failure> failures) {
        try {
            StringBuilder builder = new StringBuilder();
            for (Failure failure : failures) {
                builder.append(" [");
                builder.append(failure.getContent());
                builder.append("] ");
            }
            return "Error message: " + StringUtils.normalizeSpace((String)builder.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    private String makeStatus(List<Failure> failures) throws Exception {
        if (failures.isEmpty()) {
            return PASSED;
        }
        return FAILED;
    }
}

