/*
 * Decompiled with CFR 0.152.
 */
package report.donut.jaxb;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import report.donut.junit.model.ObjectFactory;
import report.donut.junit.model.Testsuite;

public class XmlUtils {
    private final ObjectFactory factory = new ObjectFactory();

    public List<Testsuite> unmarshal(String folderPath) throws Exception {
        File file = new File(folderPath);
        if (file.isFile()) {
            throw new Exception("Provided path is that of a file. Please provide path of the folder containing result xmls.");
        }
        if (file.isDirectory()) {
            List files = (List)FileUtils.listFiles((File)file, (String[])new String[]{"xml"}, (boolean)true);
            ArrayList<Testsuite> testsuites = new ArrayList<Testsuite>();
            for (File resultFile : files) {
                testsuites.add(this.unmarshal(resultFile));
            }
            return testsuites;
        }
        throw new Exception("Provided path isn't a directory or the path isn't absolute.");
    }

    private Testsuite unmarshal(File file) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{this.factory.getClass()});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (Testsuite)unmarshaller.unmarshal(file);
    }
}

