/*
 * Decompiled with CFR 0.152.
 */
package report.donut.reporter;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import report.donut.gherkin.model.Feature;
import report.donut.reporter.EntityGsonBuilder;

public class Reporter {
    public static final String OUTPUT_FOLDER_NAME = "junit-reports";
    private final Gson gson = EntityGsonBuilder.createGson();

    public void writeJsons(List<Feature> features, String outputDir) {
        for (Feature feature : features) {
            String json = this.gson.toJson((Object)new Feature[]{feature}, Feature[].class);
            String fileName = features.indexOf(feature) + 1 + ".json";
            if (StringUtils.isBlank((CharSequence)outputDir)) {
                outputDir = new File("./target").exists() ? "./target" : ".";
            }
            File jsonFile = new File(outputDir, OUTPUT_FOLDER_NAME + File.separator + fileName);
            try {
                FileUtils.writeStringToFile((File)jsonFile, (String)json, (String)"UTF-8");
            }
            catch (IOException e) {
                System.out.println("Couldn't write to file" + jsonFile.getAbsolutePath());
            }
        }
    }
}

