/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TokenStream;

public class IRFactory {
    private TokenStream ts;
    private Scriptable scope;

    public IRFactory(TokenStream tokenStream, Scriptable scriptable) {
        this.ts = tokenStream;
        this.scope = scriptable;
    }

    public Object createScript(Object object, String string, int n, int n2, Object object2) {
        Node node = new Node(146, string);
        Node node2 = ((Node)object).getFirstChild();
        if (node2 != null) {
            node.addChildrenToBack(node2);
        }
        node.putProp(16, string);
        node.putIntProp(28, n);
        node.putIntProp(29, n2);
        if (object2 != null) {
            node.putProp(17, object2);
        }
        return node;
    }

    public Object createLeaf(int n) {
        return new Node(n);
    }

    public Object createLeaf(int n, String string) {
        return new Node(n, string);
    }

    public Object createLeaf(int n, int n2) {
        return new Node(n, n2);
    }

    public int getLeafType(Object object) {
        Node node = (Node)object;
        return node.getType();
    }

    public Object createSwitch(int n) {
        return new Node(115, n);
    }

    public Object createVariables(int n) {
        return new Node(123, n);
    }

    public Object createExprStatement(Object object, int n) {
        return new Node(140, (Node)object, n);
    }

    public Object createName(String string) {
        return new Node(44, string);
    }

    public Object createString(String string) {
        return new Node(46, string);
    }

    public Object createNumber(double d) {
        return new Node(45, d);
    }

    public Object createCatch(String string, Object object, Object object2, int n) {
        if (object == null) {
            object = new Node(109, 52);
        }
        Node node = new Node(125, (Node)this.createName(string), (Node)object, (Node)object2);
        node.setDatum(new Integer(n));
        return node;
    }

    public Object createThrow(Object object, int n) {
        return new Node(62, (Node)object, n);
    }

    public Object createReturn(Object object, int n) {
        return object == null ? new Node(5, n) : new Node(5, (Node)object, n);
    }

    public Object createLabel(String string, int n) {
        Node node = new Node(136, n);
        Node node2 = new Node(44, string);
        node.addChildToBack(node2);
        return node;
    }

    public Object createBreak(String string, int n) {
        Node node = new Node(121, n);
        if (string == null) {
            return node;
        }
        Node node2 = new Node(44, string);
        node.addChildToBack(node2);
        return node;
    }

    public Object createContinue(String string, int n) {
        Node node = new Node(122, n);
        if (string == null) {
            return node;
        }
        Node node2 = new Node(44, string);
        node.addChildToBack(node2);
        return node;
    }

    public Object createBlock(int n) {
        return new Node(133, n);
    }

    public Object createFunctionNode(String string, Object object, Object object2) {
        if (string == null) {
            string = "";
        }
        return new FunctionNode(string, (Node)object, (Node)object2);
    }

    public Object createFunction(String string, Object object, Object object2, String string2, int n, int n2, Object object3, boolean bl) {
        FunctionNode functionNode = (FunctionNode)this.createFunctionNode(string, object, object2);
        functionNode.setFunctionType(bl ? (byte)2 : 1);
        functionNode.putProp(16, string2);
        functionNode.putIntProp(28, n);
        functionNode.putIntProp(29, n2);
        if (object3 != null) {
            functionNode.putProp(17, object3);
        }
        Node node = new Node(110, string);
        node.putProp(5, functionNode);
        return node;
    }

    public void setFunctionExpressionStatement(Object object) {
        Node node = (Node)object;
        FunctionNode functionNode = (FunctionNode)node.getProp(5);
        functionNode.setFunctionType((byte)3);
    }

    public void addChildToBack(Object object, Object object2) {
        ((Node)object).addChildToBack((Node)object2);
    }

    public Object createWhile(Object object, Object object2, int n) {
        Node node = (Node)this.createDoWhile(object2, object, n);
        Node node2 = (Node)node.getProp(3);
        Node node3 = new Node(6);
        node3.putProp(1, node2);
        node.addChildToFront(node3);
        return node;
    }

    public Object createDoWhile(Object object, Object object2, int n) {
        Node node = new Node(138, n);
        Node node2 = new Node(137);
        Node node3 = new Node(137);
        Node node4 = new Node(7, (Node)object2);
        node4.putProp(1, node2);
        Node node5 = new Node(137);
        node.addChildToBack(node2);
        node.addChildrenToBack((Node)object);
        node.addChildToBack(node3);
        node.addChildToBack(node4);
        node.addChildToBack(node5);
        node.putProp(2, node5);
        node.putProp(3, node3);
        return node;
    }

    public Object createFor(Object object, Object object2, Object object3, Object object4, int n) {
        if (((Node)object2).getType() == 132) {
            object2 = new Node(109, 52);
        }
        Node node = (Node)this.createWhile(object2, object4, n);
        Node node2 = (Node)object;
        if (node2.getType() != 132) {
            if (node2.getType() != 123) {
                node2 = new Node(57, node2);
            }
            node.addChildToFront(node2);
        }
        Node node3 = (Node)node.getProp(3);
        Node node4 = new Node(137);
        node.addChildBefore(node4, node3);
        if (((Node)object3).getType() != 132) {
            object3 = this.createUnary(57, object3);
            node.addChildAfter((Node)object3, node4);
        }
        node.putProp(3, node4);
        return node;
    }

    public Object createForIn(Object object, Object object2, Object object3, int n) {
        Node node = (Node)object;
        Node node2 = (Node)object2;
        int n2 = node.getType();
        Node node3 = node;
        switch (n2) {
            case 39: 
            case 41: 
            case 44: {
                break;
            }
            case 123: {
                Node node4 = node.getLastChild();
                if (node.getFirstChild() != node4) {
                    this.reportError("msg.mult.index");
                }
                node3 = new Node(44, node4.getString());
                break;
            }
            default: {
                this.reportError("msg.bad.for.in.lhs");
                return node2;
            }
        }
        Node node5 = new Node(79, node2);
        Node node6 = new Node(80);
        node6.putProp(4, node5);
        Node node7 = this.createNewTemp(node6);
        Node node8 = new Node(102, 15);
        node8.addChildToBack(node7);
        node8.addChildToBack(new Node(109, 49));
        Node node9 = new Node(133);
        Node node10 = (Node)this.createAssignment(128, node3, this.createUseTemp(node7), null, false);
        node9.addChildToBack(new Node(57, node10));
        node9.addChildToBack((Node)object3);
        Node node11 = (Node)this.createWhile(node8, node9, n);
        node11.addChildToFront(node5);
        if (n2 == 123) {
            node11.addChildToFront(node);
        }
        Node node12 = new Node(139);
        node12.putProp(4, node5);
        node11.addChildToBack(node12);
        return node11;
    }

    public Object createTryCatchFinally(Object object, Object object2, Object object3, int n) {
        Node node;
        Node node2;
        Node node3;
        Node node4;
        Node node5 = (Node)object;
        if (node5.getType() == 133 && !node5.hasChildren()) {
            return node5;
        }
        Node node6 = new Node(75, node5, n);
        Node node7 = (Node)object2;
        boolean bl = node7.hasChildren();
        boolean bl2 = false;
        Node node8 = null;
        Node node9 = null;
        if (object3 != null) {
            node8 = (Node)object3;
            boolean bl3 = bl2 = node8.getType() != 133 || node8.hasChildren();
            if (bl2) {
                node9 = new Node(137);
                node6.putProp(21, node9);
                node4 = new Node(143);
                node4.putProp(1, node9);
                node6.addChildToBack(node4);
            }
        }
        if (!bl2 && !bl) {
            return node5;
        }
        node4 = new Node(137);
        Node node10 = new Node(6);
        node10.putProp(1, node4);
        node6.addChildToBack(node10);
        if (bl) {
            Node node11;
            Node node12;
            node3 = new Node(137);
            node6.putProp(1, node3);
            node6.addChildToBack(node3);
            node2 = this.createNewLocal(new Node(132));
            node6.addChildToBack(new Node(57, node2));
            node = new Node(137);
            Node node13 = node7.getFirstChild();
            while (node13 != null) {
                node12 = new Node(133);
                int n2 = node13.getInt();
                node11 = node13.getFirstChild();
                Node node14 = node11.getNextSibling();
                Node node15 = node14.getNextSibling();
                node13.removeChild(node11);
                node13.removeChild(node14);
                node13.removeChild(node15);
                Node node16 = this.createNewLocal(new Node(77));
                Node node17 = new Node(40, node16, new Node(46, node11.getString()), this.createUseLocal(node2));
                node12.addChildToBack(new Node(57, node17));
                node15.addChildToBack(new Node(4));
                Node node18 = new Node(6);
                node18.putProp(1, node);
                node15.addChildToBack(node18);
                Node node19 = (Node)this.createIf(node14, node15, null, n2);
                Node node20 = (Node)this.createWith(this.createUseLocal(node16), node19, n2);
                node12.addChildToBack(node20);
                node6.addChildToBack(node12);
                node13 = node13.getNextSibling();
            }
            node12 = new Node(62, this.createUseLocal(node2));
            node6.addChildToBack(node12);
            node6.addChildToBack(node);
            if (bl2) {
                Node node21 = new Node(143);
                node21.putProp(1, node9);
                node6.addChildToBack(node21);
                node11 = new Node(6);
                node11.putProp(1, node4);
                node6.addChildToBack(node11);
            }
        }
        if (bl2) {
            node6.addChildToBack(node9);
            node3 = this.createNewLocal(new Node(132));
            node2 = new Node(57, node3);
            node6.addChildToBack(node2);
            node6.addChildToBack(node8);
            node = this.createUseLocal(node3);
            node.putProp(1, Boolean.TRUE);
            node6.addChildToBack(node);
        }
        node6.addChildToBack(node4);
        return node6;
    }

    public Object createWith(Object object, Object object2, int n) {
        Node node = new Node(133, n);
        node.addChildToBack(new Node(3, (Node)object));
        Node node2 = new Node(124, (Node)object2, n);
        node.addChildrenToBack(node2);
        node.addChildToBack(new Node(4));
        return node;
    }

    public Object createArrayLiteral(Object object) {
        Node node;
        Node node2;
        Node node3;
        Node node4 = node3 = new Node(30, new Node(44, "Array"));
        node3 = node2 = this.createNewTemp(node3);
        Node node5 = null;
        int n = 0;
        Node node6 = ((Node)object).getFirstChild();
        while (node6 != null) {
            node5 = node6;
            node6 = node6.getNextSibling();
            if (node5.getType() == 109 && node5.getInt() == 74) {
                ++n;
                continue;
            }
            node = new Node(42, this.createUseTemp(node2), new Node(45, n), node5);
            ++n;
            node3 = new Node(96, node3, node);
        }
        if (Context.getContext().getLanguageVersion() == 120) {
            if (node5 != null && node5.getType() == 109 && node5.getInt() == 74) {
                node = new Node(40, this.createUseTemp(node2), new Node(46, "length"), new Node(45, n));
                node3 = new Node(96, node3, node);
            }
        } else {
            node4.addChildToBack(new Node(45, n));
        }
        return new Node(96, node3, this.createUseTemp(node2));
    }

    public Object createObjectLiteral(Object object) {
        Node node;
        Node node2 = new Node(30, new Node(44, "Object"));
        node2 = node = this.createNewTemp(node2);
        Node node3 = ((Node)object).getFirstChild();
        while (node3 != null) {
            Node node4 = node3;
            node3 = node3.getNextSibling();
            int n = node4.getType() == 44 ? 40 : 42;
            Node node5 = node3;
            node3 = node3.getNextSibling();
            Node node6 = new Node(n, this.createUseTemp(node), node4, node5);
            node2 = new Node(96, node2, node6);
        }
        return new Node(96, node2, this.createUseTemp(node));
    }

    public Object createRegExp(String string, String string2) {
        return string2.length() == 0 ? new Node(56, new Node(46, string)) : new Node(56, new Node(46, string), new Node(46, string2));
    }

    public Object createIf(Object object, Object object2, Object object3, int n) {
        Node node = new Node(133, n);
        Node node2 = new Node(137);
        Node node3 = new Node(8, (Node)object);
        node3.putProp(1, node2);
        node.addChildToBack(node3);
        node.addChildrenToBack((Node)object2);
        if (object3 != null) {
            Node node4 = new Node(6);
            Node node5 = new Node(137);
            node4.putProp(1, node5);
            node.addChildToBack(node4);
            node.addChildToBack(node2);
            node.addChildrenToBack((Node)object3);
            node.addChildToBack(node5);
        } else {
            node.addChildToBack(node2);
        }
        return node;
    }

    public Object createTernary(Object object, Object object2, Object object3) {
        return this.createIf(object, object2, object3, -1);
    }

    public Object createUnary(int n, Object object) {
        Node node = (Node)object;
        if (n == 31) {
            Node node2;
            Node node3;
            int n2 = node.getType();
            if (n2 == 44) {
                node.setType(61);
                node3 = node;
                node2 = node.cloneNode();
                node2.setType(46);
            } else if (n2 == 39 || n2 == 41) {
                node3 = node.getFirstChild();
                node2 = node.getLastChild();
                node.removeChild(node3);
                node.removeChild(node2);
            } else {
                return new Node(109, 52);
            }
            return new Node(n, node3, node2);
        }
        return new Node(n, node);
    }

    public Object createUnary(int n, int n2, Object object) {
        Node node = (Node)object;
        int n3 = node.getType();
        if (n2 == 32 && n3 == 44) {
            node.setType(32);
            return node;
        }
        if (n == 106 || n == 107) {
            if (!(IRFactory.hasSideEffects(node) || n2 != 131 || n3 != 44 && n3 != 39 && n3 != 41)) {
                return new Node(n, node);
            }
            Node node2 = (Node)this.createNumber(1.0);
            return this.createAssignment(n == 106 ? 23 : 24, node, node2, ScriptRuntime.NumberClass, n2 == 131);
        }
        Node node3 = new Node(n, n2);
        node3.addChildToBack((Node)object);
        return node3;
    }

    public Object createBinary(int n, Object object, Object object2) {
        switch (n) {
            case 108: {
                n = 39;
                Node node = (Node)object2;
                node.setType(46);
                String string = node.getString();
                if (!string.equals("__proto__") && !string.equals("__parent__")) break;
                Node node2 = new Node(n, (Node)object);
                node2.putProp(19, string);
                return node2;
            }
            case 90: {
                n = 41;
            }
        }
        return new Node(n, (Node)object, (Node)object2);
    }

    public Object createBinary(int n, int n2, Object object, Object object2) {
        if (n == 97) {
            return this.createAssignment(n2, (Node)object, (Node)object2, null, false);
        }
        return new Node(n, (Node)object, (Node)object2, new Integer(n2));
    }

    public Object createAssignment(int n, Node node, Node node2, Class clazz, boolean bl) {
        int n2 = node.getType();
        Node node3 = null;
        switch (n2) {
            case 44: {
                return this.createSetName(n, node, node2, clazz, bl);
            }
            case 39: {
                String string = (String)node.getProp(19);
                if (string != null) {
                    node3 = new Node(46, string);
                }
            }
            case 41: {
                if (node3 == null) {
                    node3 = node.getLastChild();
                }
                return this.createSetProp(n2, n, node.getFirstChild(), node3, node2, clazz, bl);
            }
        }
        this.reportError("msg.bad.lhs.assign");
        return node;
    }

    private Node createConvert(Class clazz, Node node) {
        if (clazz == null) {
            return node;
        }
        Node node2 = new Node(142, node);
        node2.putProp(18, ScriptRuntime.NumberClass);
        return node2;
    }

    private Object createSetName(int n, Node node, Node node2, Class clazz, boolean bl) {
        if (n == 128) {
            node.setType(61);
            return new Node(10, node, node2);
        }
        String string = node.getString();
        if (string.equals("__proto__") || string.equals("__parent__")) {
            Node node3 = new Node(40, node, node2);
            node3.putProp(19, string);
            return node3;
        }
        Node node4 = new Node(44, string);
        if (clazz != null) {
            node4 = this.createConvert(clazz, node4);
        }
        if (bl) {
            node4 = this.createNewTemp(node4);
        }
        Node node5 = new Node(n, node4, node2);
        Node node6 = new Node(61, string);
        Node node7 = new Node(10, node6, node5);
        if (bl) {
            node7 = new Node(96, node7, this.createUseTemp(node4));
        }
        return node7;
    }

    public Node createNewTemp(Node node) {
        int n = node.getType();
        if (n == 46 || n == 45) {
            return node;
        }
        Node node2 = new Node(69, node);
        return node2;
    }

    public Node createUseTemp(Node node) {
        int n = node.getType();
        if (n == 69) {
            Node node2 = new Node(70);
            node2.putProp(6, node);
            int n2 = node.getIntProp(11, 0);
            if (n2 != Integer.MAX_VALUE) {
                node.putIntProp(11, n2 + 1);
            }
            return node2;
        }
        return node.cloneNode();
    }

    public Node createNewLocal(Node node) {
        Node node2 = new Node(144, node);
        return node2;
    }

    public Node createUseLocal(Node node) {
        int n = node.getType();
        if (n == 144) {
            Node node2 = new Node(145);
            node2.putProp(7, node);
            return node2;
        }
        return node.cloneNode();
    }

    public static boolean hasSideEffects(Node node) {
        switch (node.getType()) {
            case 10: 
            case 30: 
            case 40: 
            case 42: 
            case 43: 
            case 106: 
            case 107: {
                return true;
            }
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (IRFactory.hasSideEffects(node2)) {
                return true;
            }
            node2 = node2.getNextSibling();
        }
        return false;
    }

    private Node createSetProp(int n, int n2, Node node, Node node2, Node node3, Class clazz, boolean bl) {
        Node node4;
        Node node5;
        Node node6;
        Node node7;
        Object object;
        int n3 = n == 39 ? 40 : 42;
        Object object2 = node2.getDatum();
        if (n3 == 40 && object2 != null && object2 instanceof String && (((String)(object = (String)object2)).equals("__proto__") || ((String)object).equals("__parent__"))) {
            Node node8 = new Node(n3, node, node3);
            node8.putProp(19, object);
            return node8;
        }
        if (n2 == 128) {
            return new Node(n3, node, node2, node3);
        }
        if (node.getType() != 44 || node2.hasChildren() || IRFactory.hasSideEffects(node3) || IRFactory.hasSideEffects(node2)) {
            object = this.createNewTemp(node);
            node7 = this.createUseTemp((Node)object);
            node6 = this.createNewTemp(node2);
            node5 = this.createUseTemp(node6);
            node4 = new Node(n, node7, node5);
        } else {
            object = node.cloneNode();
            node6 = node2.cloneNode();
            node4 = new Node(n, node, node2);
        }
        if (clazz != null) {
            node4 = this.createConvert(clazz, node4);
        }
        if (bl) {
            node4 = this.createNewTemp(node4);
        }
        node7 = new Node(n2, node4, node3);
        node5 = new Node(n3, (Node)object, node6, node7);
        if (bl) {
            node5 = new Node(96, node5, this.createUseTemp(node4));
        }
        return node5;
    }

    private void reportError(String string) {
        if (this.scope != null) {
            throw NativeGlobal.constructError(Context.getContext(), "SyntaxError", ScriptRuntime.getMessage0(string), this.scope);
        }
        String string2 = Context.getMessage0(string);
        Context.reportError(string2, this.ts.getSourceName(), this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
    }
}

