/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Synchronizer;
import org.mozilla.javascript.serialize.ScriptableInputStream;
import org.mozilla.javascript.serialize.ScriptableOutputStream;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Environment;
import org.mozilla.javascript.tools.shell.Main;
import org.mozilla.javascript.tools.shell.Runner;

public class Global
extends ImporterTopLevel {
    static final String privateName = "org.mozilla.javascript.tools.shell.Global private";
    NativeArray history;
    public InputStream inStream;
    public PrintStream outStream;
    public PrintStream errStream;
    static /* synthetic */ Class class$org$mozilla$javascript$tools$shell$Global;
    static /* synthetic */ Class class$org$mozilla$javascript$Script;

    public Global(Context cx) {
        super(cx);
        String[] names = new String[]{"print", "quit", "version", "load", "help", "loadClass", "defineClass", "spawn", "sync", "serialize", "deserialize"};
        try {
            this.defineFunctionProperties(names, class$org$mozilla$javascript$tools$shell$Global == null ? (class$org$mozilla$javascript$tools$shell$Global = Global.class$("org.mozilla.javascript.tools.shell.Global")) : class$org$mozilla$javascript$tools$shell$Global, 2);
        }
        catch (PropertyException e) {
            throw new Error();
        }
        this.defineProperty(privateName, this, 2);
        Environment.defineClass(this);
        Environment environment = new Environment(this);
        this.defineProperty("environment", environment, 2);
        this.history = (NativeArray)cx.newArray((Scriptable)this, 0);
        this.defineProperty("history", this.history, 2);
    }

    public static void help(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        PrintStream out = Global.getInstance(thisObj).getOut();
        out.println(ToolErrorReporter.getMessage("msg.help"));
    }

    public static Object print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        PrintStream out = Global.getInstance(thisObj).getOut();
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                out.print(" ");
            }
            String s = Context.toString(args[i]);
            out.print(s);
            ++i;
        }
        out.println();
        return Context.getUndefinedValue();
    }

    public static void quit(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        System.exit(args.length > 0 ? (int)Context.toNumber(args[0]) : 0);
    }

    public static double version(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        double result = cx.getLanguageVersion();
        if (args.length > 0) {
            double d = Context.toNumber(args[0]);
            cx.setLanguageVersion((int)d);
        }
        return result;
    }

    public static void load(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        int i = 0;
        while (i < args.length) {
            Main.processFile(cx, thisObj, Context.toString(args[i]));
            ++i;
        }
    }

    public static void defineClass(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        Class clazz = Global.getClass(args);
        ScriptableObject.defineClass(thisObj, clazz);
    }

    public static void loadClass(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IllegalAccessException, InstantiationException, InvocationTargetException, JavaScriptException {
        Class clazz;
        if (!(class$org$mozilla$javascript$Script == null ? (class$org$mozilla$javascript$Script = Global.class$("org.mozilla.javascript.Script")) : class$org$mozilla$javascript$Script).isAssignableFrom(clazz = Global.getClass(args))) {
            throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.must.implement.Script"));
        }
        Script script = (Script)clazz.newInstance();
        script.exec(cx, thisObj);
    }

    private static Class getClass(Object[] args) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (args.length == 0) {
            throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.expected.string.arg"));
        }
        String className = Context.toString(args[0]);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.class.not.found", className));
        }
    }

    public static void serialize(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        if (args.length < 2) {
            throw Context.reportRuntimeError("Expected an object to serialize and a filename to write the serialization to");
        }
        Object obj = args[0];
        String filename = Context.toString(args[1]);
        FileOutputStream fos = new FileOutputStream(filename);
        Scriptable scope = ScriptableObject.getTopLevelScope(thisObj);
        ScriptableOutputStream out = new ScriptableOutputStream(fos, scope);
        out.writeObject(obj);
        out.close();
    }

    public static Object deserialize(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, ClassNotFoundException {
        if (args.length < 1) {
            throw Context.reportRuntimeError("Expected a filename to read the serialization from");
        }
        String filename = Context.toString(args[0]);
        FileInputStream fis = new FileInputStream(filename);
        Scriptable scope = ScriptableObject.getTopLevelScope(thisObj);
        ScriptableInputStream in = new ScriptableInputStream(fis, scope);
        Object deserialized = in.readObject();
        in.close();
        return Context.toObject(deserialized, scope);
    }

    public static Object spawn(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Runner runner;
        Scriptable scope = funObj.getParentScope();
        if (args.length != 0 && args[0] instanceof Function) {
            Object[] newArgs = null;
            if (args.length > 1 && args[1] instanceof Scriptable) {
                newArgs = cx.getElements((Scriptable)args[1]);
            }
            runner = new Runner(scope, (Function)args[0], newArgs);
        } else if (args.length != 0 && args[0] instanceof Script) {
            runner = new Runner(scope, (Script)args[0]);
        } else {
            throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.spawn.args"));
        }
        Thread thread = new Thread(runner);
        thread.start();
        return thread;
    }

    public static Object sync(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length == 1 && args[0] instanceof Function) {
            return new Synchronizer((Function)args[0]);
        }
        throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.spawn.args"));
    }

    public InputStream getIn() {
        return this.inStream == null ? System.in : this.inStream;
    }

    public void setIn(InputStream in) {
        this.inStream = in;
    }

    public PrintStream getOut() {
        return this.outStream == null ? System.out : this.outStream;
    }

    public void setOut(PrintStream out) {
        this.outStream = out;
    }

    public PrintStream getErr() {
        return this.errStream == null ? System.err : this.errStream;
    }

    public void setErr(PrintStream err) {
        this.errStream = err;
    }

    public static Global getInstance(Scriptable scope) {
        Object v = ScriptableObject.getProperty(scope, privateName);
        if (v instanceof Global) {
            return (Global)v;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

