/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.image;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.highgui.Highgui;
import org.opencv.imgproc.Imgproc;
import ro.altom.image.Color;
import ro.altom.image.ImageProperties;
import ro.altom.results.IResponse;
import ro.altom.results.ResultException;
import ro.altom.screenshots.Screenshot;
import ro.altom.system.Benchmark;
import ro.altom.system.EnvironmentConfiguration;
import ru.yandex.qatools.allure.annotations.Attachment;
import ru.yandex.qatools.allure.annotations.Step;

public class PixelComparison {
    private String screenshotName;
    private String baselineName;
    private IResponse response;
    EnvironmentConfiguration env = new EnvironmentConfiguration();
    private double[] highlightRGB = new double[]{0.0, 0.0, 255.0};
    private int diffPixels;
    private int matchingCount;
    private int heightBaselineImg;
    private int widthBaselineImg;
    private int heightComparedImg;
    private int widthComparedImg;
    private Mat highlightDiffImgMat;
    private Mat combinedDiffMat;
    private Mat baselineImgMat;
    private Mat comparedImgMat;
    private int maxPixelColorDifference = 20;
    private int totalPixels = 0;

    public PixelComparison() {
    }

    public PixelComparison(String screenshotName, IResponse response) throws ResultException {
        this.screenshotName = screenshotName;
        this.response = response;
    }

    public PixelComparison(Screenshot screenshot, IResponse response) throws IOException, ResultException {
        this.screenshotName = screenshot.capture();
        this.response = response;
    }

    public int getTotalPixels() {
        return this.totalPixels;
    }

    public void compare() throws ResultException {
        if (!this.screenshotName.contains("_screenshot_")) {
            System.out.println("[INFO] ... Baseline image was created");
        } else {
            this.baselineName = this.getBaseline(this.screenshotName);
            this.compareImages(this.baselineName, this.screenshotName);
            this.totalPixels = this.heightBaselineImg * this.widthBaselineImg;
            this.response.setResult(this.diffPixels, this.totalPixels);
        }
    }

    private void compareImages(String baselineImage, String comparedImage) {
        this.pixelByPixelComparison(baselineImage, comparedImage, this.maxPixelColorDifference);
    }

    @Step(value="Pixel by pixel comparison")
    private void pixelByPixelComparison(String baselineName, String comparedName, int maxPixelColorDifference) {
        this.matchingCount = 0;
        this.diffPixels = 0;
        this.baselineImgMat = new Mat();
        String baselinePath = String.valueOf(EnvironmentConfiguration.baselineFolder.resolve(baselineName + ".png"));
        this.baselineImgMat = Highgui.imread((String)baselinePath, (int)1);
        this.comparedImgMat = new Mat();
        String screenshotPath = String.valueOf(EnvironmentConfiguration.screenshotFolder.resolve(comparedName + ".png"));
        this.comparedImgMat = Highgui.imread((String)screenshotPath, (int)1);
        System.out.println("[INFO] ... Baseline image size: " + this.baselineImgMat.size());
        System.out.println("[INFO] ... Compared image size: " + this.comparedImgMat.size());
        this.heightBaselineImg = this.baselineImgMat.height();
        this.widthBaselineImg = this.baselineImgMat.width();
        this.heightComparedImg = this.comparedImgMat.height();
        this.widthComparedImg = this.comparedImgMat.width();
        this.resolveImageSizeDifference();
        this.prepareHighlightedDiffImage();
        this.compareImagesAlgorithm(maxPixelColorDifference);
        this.makeCombinedDiff();
        String highlightedDiffPath = String.valueOf(EnvironmentConfiguration.screenshotFolder.resolve(baselineName + "_diff_" + Benchmark.getTimestamp() + ".png"));
        Highgui.imwrite((String)highlightedDiffPath, (Mat)this.combinedDiffMat);
        this.attachCombinedDiffInReport(highlightedDiffPath);
    }

    public Mat getCombinedDiff() {
        return this.combinedDiffMat;
    }

    @Step(value="Resolve images size difference")
    private void resolveImageSizeDifference() {
        ImageProperties img = new ImageProperties();
        System.out.println("[INFO] ... Resolving image size difference");
        if (this.widthBaselineImg > this.widthComparedImg) {
            this.baselineImgMat = img.resize(this.baselineImgMat, this.widthComparedImg);
            this.widthBaselineImg = this.baselineImgMat.width();
            this.heightBaselineImg = this.baselineImgMat.height();
        } else {
            this.comparedImgMat = img.resize(this.comparedImgMat, this.widthBaselineImg);
            this.widthComparedImg = this.comparedImgMat.width();
            this.heightComparedImg = this.comparedImgMat.height();
        }
    }

    @Step(value="Prepare highlighted diff image")
    private void prepareHighlightedDiffImage() {
        block5: {
            int maxWidth;
            int maxHeight;
            block4: {
                maxHeight = Math.max(this.baselineImgMat.height(), this.comparedImgMat.height());
                maxWidth = Math.max(this.baselineImgMat.width(), this.comparedImgMat.width());
                this.highlightDiffImgMat = new Mat(maxHeight, maxWidth, 16);
                this.baselineImgMat.copyTo(this.highlightDiffImgMat);
                if (this.highlightDiffImgMat.height() >= maxHeight) break block4;
                Mat outM = new Mat(maxHeight - this.highlightDiffImgMat.height(), maxWidth, 16);
                this.highlightDiffImgMat.push_back(outM);
                for (int i = this.baselineImgMat.height(); i < this.highlightDiffImgMat.height(); ++i) {
                    for (int j = 0; j < maxWidth; ++j) {
                        ++this.diffPixels;
                        double[] dataDiff = this.highlightRGB;
                        this.highlightDiffImgMat.put(i, j, dataDiff);
                    }
                }
                break block5;
            }
            if (this.comparedImgMat.height() >= maxHeight) break block5;
            for (int i = this.comparedImgMat.height(); i < this.highlightDiffImgMat.height(); ++i) {
                for (int j = 0; j < maxWidth; ++j) {
                    ++this.diffPixels;
                    double[] dataDiff = this.highlightRGB;
                    this.highlightDiffImgMat.put(i, j, dataDiff);
                }
            }
        }
    }

    @Step(value="Compare images")
    private void compareImagesAlgorithm(int maxPixelColorDifference) {
        int minHeight = Math.min(this.baselineImgMat.height(), this.comparedImgMat.height());
        int minWidth = Math.min(this.baselineImgMat.width(), this.comparedImgMat.width());
        for (int i = 0; i < minHeight; ++i) {
            for (int j = 0; j < minWidth; ++j) {
                double[] data2;
                double[] data1 = this.baselineImgMat.get(i, j);
                if (Math.abs(data1[0] - (data2 = this.comparedImgMat.get(i, j))[0]) <= (double)maxPixelColorDifference && Math.abs(data1[1] - data2[1]) <= (double)maxPixelColorDifference && Math.abs(data1[2] - data2[2]) <= (double)maxPixelColorDifference) {
                    ++this.matchingCount;
                    continue;
                }
                ++this.diffPixels;
                double[] dataDiff = this.highlightRGB;
                this.highlightDiffImgMat.put(i, j, dataDiff);
            }
        }
    }

    @Step(value="Make combined diff")
    private void makeCombinedDiff() {
        int j;
        int l;
        int i;
        Mat baselineImgMatFramed = new Mat(this.heightBaselineImg, this.widthBaselineImg, 16);
        Mat comparedImgMatFramed = new Mat(this.heightComparedImg, this.widthComparedImg, 16);
        Mat highlightDiffImgMatFramed = new Mat(this.highlightDiffImgMat.height(), this.highlightDiffImgMat.width(), 16);
        Imgproc.copyMakeBorder((Mat)this.baselineImgMat, (Mat)baselineImgMatFramed, (int)10, (int)10, (int)10, (int)5, (int)0);
        Imgproc.copyMakeBorder((Mat)this.comparedImgMat, (Mat)comparedImgMatFramed, (int)10, (int)10, (int)5, (int)5, (int)0);
        Imgproc.copyMakeBorder((Mat)this.highlightDiffImgMat, (Mat)highlightDiffImgMatFramed, (int)10, (int)10, (int)5, (int)10, (int)0);
        int widthCombinedDiff = baselineImgMatFramed.width() + comparedImgMatFramed.width() + highlightDiffImgMatFramed.width();
        int heightCombinedDiff = highlightDiffImgMatFramed.height();
        this.combinedDiffMat = new Mat(heightCombinedDiff, widthCombinedDiff, CvType.CV_64FC((int)3));
        for (int i2 = 0; i2 < baselineImgMatFramed.height(); ++i2) {
            for (int j2 = 0; j2 < baselineImgMatFramed.width(); ++j2) {
                double[] baselinePixel = baselineImgMatFramed.get(i2, j2);
                this.combinedDiffMat.put(i2, j2, baselinePixel);
            }
        }
        int k = 0;
        for (i = 0; i < comparedImgMatFramed.height(); ++i) {
            l = 0;
            for (j = baselineImgMatFramed.width(); j < baselineImgMatFramed.width() + comparedImgMatFramed.width(); ++j) {
                double[] comparedPixel = comparedImgMatFramed.get(k, l);
                ++l;
                this.combinedDiffMat.put(i, j, comparedPixel);
            }
            ++k;
        }
        k = 0;
        for (i = 0; i < highlightDiffImgMatFramed.height(); ++i) {
            l = 0;
            for (j = baselineImgMatFramed.width() + comparedImgMatFramed.width(); j < this.combinedDiffMat.width(); ++j) {
                double[] highlightPixel = highlightDiffImgMatFramed.get(k, l);
                ++l;
                this.combinedDiffMat.put(i, j, highlightPixel);
            }
            ++k;
        }
        this.baselineImgMat.release();
        this.comparedImgMat.release();
        this.highlightDiffImgMat.release();
        baselineImgMatFramed.release();
        comparedImgMatFramed.release();
        highlightDiffImgMatFramed.release();
    }

    @Step(value="Changed highlight color to {0}")
    public void setHighlightColor(String color) {
        Color c = new Color();
        this.highlightRGB = c.setColor(color.toLowerCase());
    }

    @Step(value="Save CombinedDiff in report: {0}")
    @Attachment(value="{0}", type="image/png")
    private byte[] attachCombinedDiffInReport(String fileNamePath) {
        Path path = Paths.get(fileNamePath, new String[0]);
        byte[] data = new byte[]{};
        try {
            data = Files.readAllBytes(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    public String getBaseline(String screenshotName) {
        String[] parts = screenshotName.split("_screenshot_");
        return parts[0];
    }

    void setDiffList(List<Mat> list, String name) {
        try {
            Mat finalDiffMat = new Mat();
            Core.vconcat(list, (Mat)finalDiffMat);
            String fullpageDiffPath = String.valueOf(EnvironmentConfiguration.screenshotFolder.resolve(name + "_FULL_PAGE_DIFF_" + Benchmark.getTimestamp() + ".png"));
            Highgui.imwrite((String)fullpageDiffPath, (Mat)finalDiffMat);
            this.attachCombinedDiffInReport(fullpageDiffPath);
            finalDiffMat.release();
        }
        catch (NullPointerException ex) {
            System.err.println("[INFO] ... There are no images for creating combined diff");
        }
    }
}

