/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.image;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import ro.altom.image.PixelComparison;
import ro.altom.results.BinaryResponse;
import ro.altom.results.IResponse;
import ro.altom.results.PercentageResponse;
import ro.altom.results.PixelResponse;
import ro.altom.results.ResultException;
import ro.altom.screenshots.FullPageScreenshot;
import ro.altom.screenshots.Screenshot;

public class UICheck {
    public static Mat combinedDiff;
    private static int totalPixels;

    public static boolean binary(Screenshot screenshot, Boolean magentaColor) throws IOException, ResultException {
        return UICheck.binaryResponse(screenshot, magentaColor);
    }

    public static boolean binary(Screenshot screenshot) throws IOException, ResultException {
        return UICheck.binaryResponse(screenshot, false);
    }

    public static List<Boolean> binaryMultiple(FullPageScreenshot screenshot) throws InterruptedException, ResultException, IOException {
        return UICheck.binaryMultipleResponse(screenshot);
    }

    public static double percentage(Screenshot screenshot, Boolean magentaColor) throws IOException, ResultException {
        return UICheck.percentageResponse(screenshot, magentaColor);
    }

    public static double percentage(Screenshot screenshot) throws IOException, ResultException {
        return UICheck.percentageResponse(screenshot, false);
    }

    public static List<Double> percentageMultiple(FullPageScreenshot screenshot) throws InterruptedException, ResultException, IOException {
        return UICheck.percentageMultipleResponse(screenshot);
    }

    public static int pixel(Screenshot screenshot, Boolean magentaColor) throws IOException, ResultException {
        return UICheck.pixelResponse(screenshot, magentaColor);
    }

    public static int pixel(Screenshot screenshot) throws IOException, ResultException {
        return UICheck.pixelResponse(screenshot, false);
    }

    public static List<Integer> pixelMultiple(FullPageScreenshot screenshot) throws InterruptedException, ResultException, IOException {
        return UICheck.pixelMultipleResponse(screenshot);
    }

    private static boolean binaryResponse(Screenshot screenshot, Boolean magentaColor) throws ResultException, IOException {
        BinaryResponse response = new BinaryResponse();
        PixelComparison pc = new PixelComparison(screenshot, (IResponse)response);
        if (magentaColor.booleanValue()) {
            pc.setHighlightColor("magenta");
        }
        pc.compare();
        combinedDiff = pc.getCombinedDiff();
        return response.getResult();
    }

    private static List<Boolean> binaryMultipleResponse(FullPageScreenshot screenshot) throws InterruptedException, ResultException, IOException {
        List<Integer> pixelResponseList = screenshot.checkPixels();
        ArrayList<Boolean> binaryResponseList = new ArrayList<Boolean>();
        int i = 0;
        for (Integer result : pixelResponseList) {
            BinaryResponse binaryResponse = new BinaryResponse();
            binaryResponse.setResult(result, totalPixels);
            binaryResponseList.add(i, binaryResponse.getResult());
            if (!screenshot.checkIfBaseline()) {
                System.out.println("[INFO] ... " + screenshot.getName() + String.valueOf(i) + " ---> similar baseline: " + binaryResponse.getResult());
                System.out.println("-------------------------------------------------------");
            }
            ++i;
        }
        return binaryResponseList;
    }

    private static double percentageResponse(Screenshot screenshot, Boolean magentaColor) throws ResultException, IOException {
        PercentageResponse response = new PercentageResponse();
        PixelComparison pc = new PixelComparison(screenshot, (IResponse)response);
        if (magentaColor.booleanValue()) {
            pc.setHighlightColor("magenta");
        }
        pc.compare();
        combinedDiff = pc.getCombinedDiff();
        return response.getResult();
    }

    private static List<Double> percentageMultipleResponse(FullPageScreenshot screenshot) throws InterruptedException, ResultException, IOException {
        List<Integer> pixelResponseList = screenshot.checkPixels();
        ArrayList<Double> percentageResponseList = new ArrayList<Double>();
        int i = 0;
        for (Integer result : pixelResponseList) {
            PercentageResponse percentageResponse = new PercentageResponse();
            percentageResponse.setResult(result, totalPixels);
            percentageResponseList.add(i, percentageResponse.getResult());
            if (!screenshot.checkIfBaseline()) {
                System.out.println("[INFO] ... " + screenshot.getName() + String.valueOf(i) + " ---> percentage difference: " + percentageResponse.getResult() + "%");
                System.out.println("-------------------------------------------------------");
            }
            ++i;
        }
        return percentageResponseList;
    }

    private static int pixelResponse(Screenshot screenshot, Boolean magentaColor) throws ResultException, IOException {
        PixelResponse response = new PixelResponse();
        PixelComparison pc = new PixelComparison(screenshot, (IResponse)response);
        if (magentaColor.booleanValue()) {
            pc.setHighlightColor("magenta");
        }
        pc.compare();
        totalPixels = pc.getTotalPixels();
        combinedDiff = pc.getCombinedDiff();
        return response.getResult();
    }

    private static List<Integer> pixelMultipleResponse(FullPageScreenshot screenshot) throws InterruptedException, ResultException, IOException {
        return screenshot.checkPixels();
    }

    public void attachCombinedDiffList(List<Mat> list, String name) {
        PixelComparison pixel = new PixelComparison();
        pixel.setDiffList(list, name);
    }
}

