/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.screenshots;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;
import ro.altom.screenshots.Screenshot;
import ro.altom.system.Benchmark;
import ro.altom.system.EnvironmentConfiguration;

public class ElementScreenshot
extends Screenshot {
    RemoteWebDriver driver;
    String name;
    By element;
    int scale = 1;

    public ElementScreenshot(RemoteWebDriver driver, By element, String name) {
        if ((driver instanceof ChromeDriver || driver instanceof FirefoxDriver) && this.checkRetinaDisplay()) {
            System.out.println("[INFO] ... Retina display on Mac OS X.");
            System.out.println("[INFO] ... Change the scaling level.");
            this.scale = 2;
        }
        this.driver = driver;
        this.element = element;
        this.name = name + "_" + this.getDriverName(this.driver);
    }

    @Override
    public String capture() throws IOException {
        if (this.baselineExists(this.name)) {
            return this.screenshotElementAsQuery(this.name, this.element);
        }
        System.err.println("[INFO] ... Image not found, creating baseline for '" + this.name + "'.");
        this.newBaselineImage = true;
        return this.screenshotElementAsBaseline(this.name, this.element);
    }

    private String screenshotElementAsQuery(String screenshotName, By element) throws IOException {
        return this.screenshotElement(screenshotName, element, false);
    }

    private String screenshotElementAsBaseline(String screenshotName, By element) throws IOException {
        return this.screenshotElement(screenshotName, element, true);
    }

    private String screenshotElement(String screenshotName, By el, boolean newBaseline) throws IOException {
        Path screenshotPath;
        WebElement element = this.driver.findElement(el);
        this.driver.executeScript("arguments[0].scrollIntoView();", new Object[]{element});
        new WebDriverWait((WebDriver)this.driver, 10L).until(d -> d.findElement(el).isDisplayed());
        File urlScreenshot = (File)this.driver.getScreenshotAs(OutputType.FILE);
        BufferedImage fullImg = ImageIO.read(urlScreenshot);
        Point viewPortLocation = ((Locatable)element).getCoordinates().inViewPort();
        int y = viewPortLocation.getY() * this.scale;
        int x = viewPortLocation.getX() * this.scale;
        int elementHeight = element.getSize().getHeight();
        int elementWidth = element.getSize().getWidth();
        BufferedImage elementScreenshot = fullImg.getSubimage(x, y, elementWidth * this.scale, elementHeight * this.scale);
        ImageIO.write((RenderedImage)elementScreenshot, "png", urlScreenshot);
        if (newBaseline) {
            screenshotPath = EnvironmentConfiguration.baselineFolder.resolve(screenshotName + ".png");
        } else {
            screenshotName = screenshotName + "_screenshot_" + Benchmark.getTimestamp();
            screenshotPath = EnvironmentConfiguration.screenshotFolder.resolve(screenshotName + ".png");
        }
        FileUtils.copyFile((File)urlScreenshot, (File)screenshotPath.toFile());
        return screenshotName;
    }
}

