/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.screenshots;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.openqa.selenium.remote.RemoteWebDriver;
import ro.altom.image.UICheck;
import ro.altom.results.ResultException;
import ro.altom.screenshots.Screenshot;
import ro.altom.screenshots.ViewPortScreenshot;

public class FullPageScreenshot
extends Screenshot {
    private RemoteWebDriver driver;
    private String name;
    private long viewPortHeight;
    private long scrollPosition;
    private int i;
    private Screenshot screenshot;
    private List<Mat> diffList;
    private UICheck checker;
    private Boolean newBaselineImage;

    public FullPageScreenshot(RemoteWebDriver driver, String name) {
        this.driver = driver;
        this.name = name;
        this.viewPortHeight = this.getViewPortHeight();
        this.diffList = new ArrayList<Mat>();
        this.checker = new UICheck();
    }

    public String getName() {
        return this.name;
    }

    public boolean checkIfBaseline() {
        return this.newBaselineImage;
    }

    @Override
    public String capture() throws IOException {
        return null;
    }

    public List<Integer> checkPixels() throws ResultException, IOException, InterruptedException {
        long scrollMaxY = this.getScrollPositionMaxY();
        this.i = 0;
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        resultList.add(this.pixelCheck(this.name, this.i + 1));
        this.diffList.add(UICheck.combinedDiff);
        this.scrollPosition = this.getScrollPositionOnY();
        while (this.scrollPosition + 1L < scrollMaxY) {
            this.scrollOnePage();
            resultList.add(this.pixelCheck(this.name, this.i + 2));
            this.diffList.add(UICheck.combinedDiff);
            ++this.i;
            this.scrollPosition = this.getScrollPositionOnY();
            Thread.sleep(2000L);
            scrollMaxY = this.getScrollPositionMaxY();
        }
        this.checker.attachCombinedDiffList(this.diffList, this.name);
        this.releaseMatrices();
        return resultList;
    }

    private int pixelCheck(String imageName, int part) throws ResultException, IOException {
        this.screenshot = new ViewPortScreenshot(this.driver, imageName + part);
        int result = UICheck.pixel(this.screenshot);
        this.newBaselineImage = this.screenshot.newBaselineImage;
        if (!this.screenshot.newBaselineImage.booleanValue()) {
            System.out.println("[INFO] ... " + imageName + String.valueOf(part) + " ---> different pixels: " + result);
            System.out.println("-------------------------------------------------------");
        }
        return result;
    }

    private long getScrollPositionMaxY() {
        long maxScroll = Long.parseLong(this.driver.executeScript("return document.querySelector(\"html\").scrollHeight - window.innerHeight", new Object[0]).toString());
        Boolean vertScrollStatus = (Boolean)this.driver.executeScript("return document.documentElement.scrollHeight > document.documentElement.clientHeight;", new Object[0]);
        return vertScrollStatus.equals(true) ? (long)Math.round(maxScroll) : 0L;
    }

    private long getViewPortHeight() {
        return Long.parseLong(this.driver.executeScript("return window.innerHeight", new Object[0]).toString());
    }

    private long getScrollPositionOnY() {
        return Long.parseLong(this.driver.executeScript("return window.scrollY", new Object[0]).toString());
    }

    private void scrollOnePage() throws InterruptedException {
        this.driver.executeScript("window.scrollBy(0," + this.viewPortHeight + ")", new Object[]{""});
        Thread.sleep(2000L);
    }

    private void releaseMatrices() {
        this.diffList.stream().filter(diff -> diff != null).forEach(Mat::release);
    }
}

