/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.screenshots;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.remote.RemoteWebDriver;
import ro.altom.screenshots.Screenshot;
import ro.altom.system.Benchmark;
import ro.altom.system.EnvironmentConfiguration;

public class ViewPortScreenshot
extends Screenshot {
    RemoteWebDriver driver;
    String name;

    public ViewPortScreenshot(RemoteWebDriver driver, String name) {
        this.driver = driver;
        this.name = name + "_" + this.getDriverName(this.driver);
    }

    @Override
    public String capture() throws IOException {
        if (this.baselineExists(this.name)) {
            return this.screenshotAsQuery(this.name);
        }
        System.err.println("[INFO] ... Image not found, creating baseline for '" + this.name + "'.");
        this.newBaselineImage = true;
        return this.screenshotAsBaseline(this.name);
    }

    private String screenshotAsQuery(String screenshotName) throws IOException {
        return this.screenshot(screenshotName, false);
    }

    private String screenshotAsBaseline(String screenshotName) throws IOException {
        return this.screenshot(screenshotName, true);
    }

    private String screenshot(String screenshotName, boolean newBaseline) throws IOException {
        Path screenshotPath;
        File urlScreenshot = (File)this.driver.getScreenshotAs(OutputType.FILE);
        if (newBaseline) {
            screenshotPath = EnvironmentConfiguration.baselineFolder.resolve(screenshotName + ".png");
        } else {
            screenshotName = screenshotName + "_screenshot_" + Benchmark.getTimestamp();
            screenshotPath = EnvironmentConfiguration.screenshotFolder.resolve(screenshotName + ".png");
        }
        FileUtils.copyFile((File)urlScreenshot, (File)screenshotPath.toFile());
        return screenshotName;
    }
}

