/*
 * Decompiled with CFR 0.152.
 */
package ro.altom.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.Properties;
import nu.pattern.OpenCV;

public class EnvironmentConfiguration {
    protected static Properties prop;
    public static Path screenshotFolder;
    public static Path baselineFolder;
    private boolean defaultBaselinePath = false;
    private static boolean pathsAlreadySet;

    public EnvironmentConfiguration() {
        prop = new Properties();
        OpenCV.loadShared();
        try {
            prop.load(new FileInputStream(new File("properties/config.properties")));
            try {
                new File(prop.getProperty("path.baseline")).toPath();
            }
            catch (NullPointerException e) {
                this.defaultBaselinePath = true;
            }
        }
        catch (IOException e) {
            this.defaultBaselinePath = true;
        }
        if (!pathsAlreadySet) {
            String allureResultsDirectoryPath = System.getProperty("user.dir") + "/target/reports/allure-results";
            System.setProperty("allure.results.directory", allureResultsDirectoryPath);
            if (!this.defaultBaselinePath) {
                baselineFolder = new File(prop.getProperty("path.baseline")).toPath();
            }
            try {
                this.createReportFolderForSpecificRun();
            }
            catch (IOException e) {
                System.out.println("Old reports directory could not be renamed with its creation date");
            }
            pathsAlreadySet = true;
        }
    }

    public void createReportFolderForSpecificRun() throws IOException {
        File reportFile = new File(System.getProperty("user.dir") + "/target/reports");
        if (reportFile.exists() && reportFile.isDirectory()) {
            File reportFileWithCreationTime = new File(System.getProperty("user.dir") + "/target/reports-" + this.getFileCreationTime(reportFile));
            reportFile.renameTo(reportFileWithCreationTime);
        }
    }

    public String getFileCreationTime(File file) throws IOException {
        Path p = Paths.get(file.getAbsolutePath(), new String[0]);
        BasicFileAttributes view = Files.getFileAttributeView(p, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
        FileTime fileTime = view.creationTime();
        return new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(fileTime.toMillis());
    }

    public String getPlatformName() {
        return System.getProperty("os.name");
    }

    static {
        screenshotFolder = new File(System.getProperty("user.dir") + "/target/reports/screenshots/").toPath();
        baselineFolder = new File(System.getProperty("user.dir") + "/img/").toPath();
        pathsAlreadySet = false;
    }
}

