/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.screen.image.input;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import tdl.record.screen.image.input.ImageInput;
import tdl.record.screen.image.input.InputImageGenerationException;

public class EnsureEvenHeightAndWidth
implements ImageInput {
    private final ImageInput originalInputSource;

    public EnsureEvenHeightAndWidth(ImageInput originalImageSource) {
        this.originalInputSource = originalImageSource;
    }

    @Override
    public void open() throws InputImageGenerationException {
        this.originalInputSource.open();
    }

    @Override
    public BufferedImage readImage() throws InputImageGenerationException {
        return this.processImage(this.originalInputSource.readImage());
    }

    @Override
    public BufferedImage getSampleImage() throws InputImageGenerationException {
        return this.processImage(this.originalInputSource.getSampleImage());
    }

    private BufferedImage processImage(BufferedImage originalImage) {
        if (EnsureEvenHeightAndWidth.needsProcessing(originalImage)) {
            int width = EnsureEvenHeightAndWidth.ensureEven(originalImage.getWidth());
            int height = EnsureEvenHeightAndWidth.ensureEven(originalImage.getHeight());
            Raster data = originalImage.getData(new Rectangle(0, 0, width, height));
            WritableRaster writableRaster = data.createCompatibleWritableRaster();
            writableRaster.setDataElements(0, 0, data);
            return new BufferedImage(originalImage.getColorModel(), writableRaster, originalImage.isAlphaPremultiplied(), null);
        }
        return originalImage;
    }

    private static boolean needsProcessing(BufferedImage originalImage) {
        return EnsureEvenHeightAndWidth.isOdd(originalImage.getHeight()) || EnsureEvenHeightAndWidth.isOdd(originalImage.getWidth());
    }

    @Override
    public int getWidth() {
        return EnsureEvenHeightAndWidth.ensureEven(this.originalInputSource.getWidth());
    }

    @Override
    public int getHeight() {
        return EnsureEvenHeightAndWidth.ensureEven(this.originalInputSource.getHeight());
    }

    private static int ensureEven(int length) {
        return EnsureEvenHeightAndWidth.isOdd(length) ? length - 1 : length;
    }

    private static boolean isOdd(int length) {
        return length % 2 == 1;
    }

    @Override
    public void close() {
        this.originalInputSource.close();
    }
}

