/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.screen.image.input;

import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import tdl.record.screen.image.input.ImageInput;
import tdl.record.screen.image.input.InputImageGenerationException;
import tdl.record.screen.utils.ImageConversion;

public class InputFromScreen
implements ImageInput {
    private static final int IMAGE_TYPE = 5;
    private Rectangle screenBounds = null;
    private Robot robot = null;
    private GraphicsDevice screenDevice;

    public InputFromScreen() {
        this(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    public InputFromScreen(GraphicsDevice screenDevice) {
        this.screenDevice = screenDevice;
    }

    @Override
    public void open() throws InputImageGenerationException {
        try {
            this.robot = new Robot(this.screenDevice);
            this.screenBounds = this.screenDevice.getDefaultConfiguration().getBounds();
        }
        catch (AWTException e) {
            throw new InputImageGenerationException(e);
        }
    }

    @Override
    public BufferedImage readImage() {
        BufferedImage screenCapture = this.robot.createScreenCapture(this.screenBounds);
        return ImageConversion.convertToType(screenCapture, 5);
    }

    @Override
    public BufferedImage getSampleImage() {
        return new BufferedImage(this.screenBounds.width, this.screenBounds.height, 5);
    }

    @Override
    public int getWidth() {
        return this.screenBounds.width;
    }

    @Override
    public int getHeight() {
        return this.screenBounds.height;
    }

    @Override
    public void close() {
    }
}

