/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.screen.image.input;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import tdl.record.screen.image.input.ImageInput;
import tdl.record.screen.image.input.InputImageGenerationException;
import tdl.record.screen.utils.ImageQualityHint;
import tdl.record.screen.utils.ImageResolution;
import tdl.record.screen.utils.ImageResolutionPicker;

public class ScaleToOptimalSizeImage
implements ImageInput {
    private final ImageInput originalInputSource;
    private final ImageQualityHint imageQualityHint;
    private ImageResolution maxResolution;
    private BufferedImage targetImage;
    private AffineTransformOp scaleDownTransform;

    public ScaleToOptimalSizeImage(ImageQualityHint imageQualityHint, ImageInput originalImageSource) {
        this.originalInputSource = originalImageSource;
        this.imageQualityHint = imageQualityHint;
    }

    @Override
    public void open() throws InputImageGenerationException {
        ImageResolution sourceResolution;
        this.originalInputSource.open();
        this.maxResolution = sourceResolution = ImageResolution.of(this.originalInputSource.getWidth(), this.originalInputSource.getHeight());
        if (ImageResolutionPicker.canSupport(sourceResolution.getRatio())) {
            this.maxResolution = ImageResolutionPicker.maxResolutionFor(sourceResolution.getRatio(), this.imageQualityHint);
        }
        if (sourceResolution.getNumPixels() > this.maxResolution.getNumPixels()) {
            this.targetImage = new BufferedImage(this.maxResolution.getWidth(), this.maxResolution.getHeight(), 5);
            double sx = (double)this.maxResolution.getWidth() / (double)this.originalInputSource.getWidth();
            double sy = (double)this.maxResolution.getHeight() / (double)this.originalInputSource.getHeight();
            AffineTransform at = new AffineTransform();
            at.scale(sx, sy);
            this.scaleDownTransform = new AffineTransformOp(at, 3);
        } else {
            this.targetImage = new BufferedImage(sourceResolution.getWidth(), sourceResolution.getHeight(), 5);
        }
    }

    @Override
    public BufferedImage readImage() throws InputImageGenerationException {
        return this.processImage(this.originalInputSource.readImage());
    }

    @Override
    public BufferedImage getSampleImage() throws InputImageGenerationException {
        return this.processImage(this.originalInputSource.getSampleImage());
    }

    private BufferedImage processImage(BufferedImage originalImage) throws InputImageGenerationException {
        if (originalImage.getWidth() * originalImage.getHeight() > this.maxResolution.getNumPixels()) {
            this.scaleDownTransform.filter(originalImage, this.targetImage);
        } else {
            this.targetImage = originalImage;
        }
        return this.targetImage;
    }

    @Override
    public int getWidth() {
        return this.targetImage.getWidth();
    }

    @Override
    public int getHeight() {
        return this.targetImage.getHeight();
    }

    @Override
    public void close() {
        this.originalInputSource.close();
    }
}

