/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.screen.metrics;

import io.humble.video.Rational;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tdl.record.screen.metrics.VideoRecordingListener;

public class VideoRecordingMetricsCollector
implements VideoRecordingListener {
    private static final Logger log = LoggerFactory.getLogger(VideoRecordingMetricsCollector.class);
    private long expectedTimeBetweenFramesNanos = Long.MAX_VALUE;
    private long timestampBeforeProcessingNanos = 0L;
    private double renderingTimeRatio = 0.0;
    private long totalFrames = 0L;
    private Path destinationPath;
    private Rational inputFrameRate = Rational.make();
    private Rational videoFrameRate = Rational.make();
    private boolean isCurrentlyRecording;

    @Override
    public void notifyRecordingStart(String destinationFilename, Rational inputFrameRate, Rational videoFrameRate) {
        this.destinationPath = Paths.get(destinationFilename, new String[0]);
        this.inputFrameRate = inputFrameRate;
        this.videoFrameRate = videoFrameRate;
        double timeBetweenFramesMillis = inputFrameRate.getValue() * 1000.0;
        this.expectedTimeBetweenFramesNanos = TimeUnit.MILLISECONDS.toNanos((long)timeBetweenFramesMillis);
        this.isCurrentlyRecording = true;
        log.info("Start recording to \"" + this.destinationPath.getFileName() + "\" at " + videoFrameRate.getDenominator() + " fps with " + inputFrameRate.getDenominator() + " screenshots/sec");
    }

    @Override
    public void notifyFrameRenderingStart(long timestamp, TimeUnit unit, long frameIndex) {
        log.debug("Snap ! {}", (Object)frameIndex);
        this.timestampBeforeProcessingNanos = unit.toNanos(timestamp);
    }

    @Override
    public void notifyFrameRenderingEnd(long timestamp, TimeUnit unit, long frameIndex) {
        long timeSpendProcessingNanos = unit.toNanos(timestamp) - this.timestampBeforeProcessingNanos;
        this.renderingTimeRatio = (double)timeSpendProcessingNanos / (double)this.expectedTimeBetweenFramesNanos;
        log.debug("renderingTimeRatio: {}", (Object)this.renderingTimeRatio);
        this.totalFrames = frameIndex;
    }

    @Override
    public void notifyRecordingEnd() {
        this.isCurrentlyRecording = false;
        log.info("Recording stopped");
    }

    public boolean isCurrentlyRecording() {
        return this.isCurrentlyRecording;
    }

    public Path getDestinationPath() {
        return this.destinationPath;
    }

    public Rational getInputFrameRate() {
        return this.inputFrameRate;
    }

    public Rational getVideoFrameRate() {
        return this.videoFrameRate;
    }

    public double getRenderingTimeRatio() {
        return this.renderingTimeRatio;
    }

    public long getTotalFrames() {
        return this.totalFrames;
    }
}

