/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.screen.time;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tdl.record.screen.time.TimeSource;

public class SystemTimeSource
implements TimeSource {
    private static final Logger log = LoggerFactory.getLogger(SystemTimeSource.class);

    @Override
    public long currentTimeNano() {
        return System.nanoTime();
    }

    @Override
    public void wakeUpAt(long timestamp, TimeUnit timeUnit) throws InterruptedException {
        long currentTimestampNano = this.currentTimeNano();
        long targetTimestampNano = timeUnit.toNanos(timestamp);
        long timeToSleepMillis = TimeUnit.NANOSECONDS.toMillis(targetTimestampNano - currentTimestampNano);
        if (timeToSleepMillis > 1L) {
            log.debug("Sleep for: {} millis", (Object)timeToSleepMillis);
            Thread.sleep(timeToSleepMillis);
        }
    }
}

