/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.screen.utils;

public class ImageResolution {
    private final int width;
    private final int height;

    private ImageResolution(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public static ImageResolution of(int width, int height) {
        return new ImageResolution(width, height);
    }

    static ImageResolution of(String resolution) {
        String[] split = resolution.split("x");
        int width = Integer.parseInt(split[0]);
        int height = Integer.parseInt(split[1]);
        return ImageResolution.of(width, height);
    }

    public int getNumPixels() {
        return this.width * this.height;
    }

    public double getRatio() {
        return (double)this.width / (double)this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return "ImageResolution{width=" + this.width + ", height=" + this.height + '}';
    }
}

