/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.screen.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import tdl.record.screen.utils.ImageQualityHint;
import tdl.record.screen.utils.ImageResolution;

public class ImageResolutionPicker {
    public static boolean canSupport(double ratio) {
        return Resolutions.forRatio(ratio).isPresent();
    }

    public static ImageResolution maxResolutionFor(double ratio, ImageQualityHint imageQualityHint) {
        List eligibleResolutions = Resolutions.forRatio(ratio).map(Resolutions::getResolutions).orElseThrow(() -> new IllegalArgumentException("Resolution not supported"));
        return eligibleResolutions.stream().filter(imageResolution -> imageResolution.getNumPixels() <= imageQualityHint.getMaxNumPixels()).sorted(Comparator.comparing(ImageResolution::getNumPixels).reversed()).findFirst().orElseThrow(() -> new IllegalArgumentException("The quality hints are not balanced correctly"));
    }

    private static List<ImageResolution> from(String ... resolutions) {
        ArrayList<ImageResolution> resolutionList = new ArrayList<ImageResolution>();
        for (String resolution : resolutions) {
            resolutionList.add(ImageResolution.of(resolution));
        }
        return resolutionList;
    }

    static /* synthetic */ List access$000(String[] x0) {
        return ImageResolutionPicker.from(x0);
    }

    static enum Resolutions {
        R4_3(1.3333333333333333, ImageResolutionPicker.access$000(new String[]{"640x480", "800x600", "960x720", "1024x768", "1280x960", "1400x1050", "1440x1080", "1600x1200", "1856x1392", "1920x1440", "2048x1536"})),
        R16_10(1.6, ImageResolutionPicker.access$000(new String[]{"1280x800", "1440x900", "1680x1050", "1920x1200", "2560x1600"})),
        R16_9(1.7777777777777777, ImageResolutionPicker.access$000(new String[]{"1024x576", "1152x648", "1280x720", "1366x768", "1600x900", "1920x1080", "2560x1440", "3840x2160"}));

        private double ratio;
        private List<ImageResolution> resolutions;

        public static Optional<Resolutions> forRatio(double ratio) {
            return Arrays.stream(Resolutions.values()).filter(resolutions -> Math.abs(resolutions.ratio - ratio) < 0.1).findFirst();
        }

        private Resolutions(double ratio, List<ImageResolution> resolutions) {
            this.ratio = ratio;
            this.resolutions = resolutions;
        }

        public List<ImageResolution> getResolutions() {
            return this.resolutions;
        }
    }
}

