/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.sourcecode;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import tdl.record.sourcecode.Command;
import tdl.record.sourcecode.snapshot.file.ToGitConverter;
import tdl.record.sourcecode.snapshot.helpers.GitHelper;

@Parameters(commandDescription="Convert a SRCS file to git repository.")
public class ConvertToGitCommand
extends Command {
    private Path outputPath;
    @Parameter(names={"-i", "--input"}, required=true, description="The SRCS input file")
    public String inputFilePath;
    @Parameter(names={"-o", "--output"}, required=true, description="The destination sourceCodeProvider. Warning! It will be cleared if exists.")
    public String outputDirectoryPath;
    @Parameter(names={"--clean-dest"}, description="Remove destination, even if git repo.")
    public boolean wipeDestinationRepo = false;
    @Parameter(names={"--ignore-errors"}, description="Continue processing even if errors occur")
    public boolean ignoreErrors = false;

    @Override
    public void run() {
        this.outputPath = Paths.get(this.outputDirectoryPath, new String[0]);
        this.createDirectoryIfNotExists();
        this.cleanDirectoryIfOkay();
        try {
            ToGitConverter converter = new ToGitConverter(Paths.get(this.inputFilePath, new String[0]), this.outputPath, segment -> System.out.format("Committing timestamp: %d (type: %s, size: %d, tag: %s)%n", segment.getTimestampSec(), segment.getType().name(), segment.getSize(), segment.getTag()), !this.ignoreErrors);
            converter.convert();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void createDirectoryIfNotExists() {
        File file = this.outputPath.toFile();
        try {
            if (file.isFile()) {
                FileUtils.deleteQuietly((File)file);
            }
            if (!file.exists()) {
                FileUtils.forceMkdir((File)file);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void cleanDirectoryIfOkay() {
        if (!GitHelper.isGitDirectory(this.outputPath) || this.wipeDestinationRepo) {
            try {
                FileUtils.cleanDirectory((File)this.outputPath.toFile());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

