/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.sourcecode;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import tdl.record.sourcecode.Command;
import tdl.record.sourcecode.snapshot.file.Header;
import tdl.record.sourcecode.snapshot.file.Reader;
import tdl.record.sourcecode.snapshot.file.Segment;
import tdl.record.sourcecode.snapshot.file.TagManager;
import tdl.record.sourcecode.snapshot.file.Writer;

@Parameters(commandDescription="Export segments in a SCRS file into a separate SRCS file.")
public class ExportSegmentsCommand
extends Command {
    private static final boolean APPEND_TO_THE_END_OF_THE_FILE = true;
    @Parameter(names={"-i", "--input"}, required=true, description="The SRCS input file.")
    private String inputFilePath;
    @Parameter(names={"-o", "--output"}, required=true, description="Path to the output segments file. Freshly created.")
    private String outputFilePath;
    @Parameter(names={"-ts", "--timestamp"}, description="Export the state of the repo at the given timestamp.")
    private long timeStamp = 0L;
    @Parameter(names={"--tag"}, description="Export a specific tag")
    private String tag = "";
    private long recordedTimestamp;
    private FileOutputStream outputStream;

    ExportSegmentsCommand() {
    }

    ExportSegmentsCommand(String inputFilePath, String outputFilePath, long timeStamp) {
        this.inputFilePath = inputFilePath;
        this.outputFilePath = outputFilePath;
        this.timeStamp = timeStamp;
        this.tag = "";
    }

    ExportSegmentsCommand(String inputFilePath, String outputFilePath, String tag) {
        this.inputFilePath = inputFilePath;
        this.outputFilePath = outputFilePath;
        this.timeStamp = 0L;
        this.tag = tag;
    }

    @Override
    public void run() {
        File file = Paths.get(this.inputFilePath, new String[0]).toFile();
        try (Reader reader = new Reader(file);){
            int index = !this.tag.isEmpty() ? reader.getIndexBeforeForTag(this.tag) : reader.getIndexBeforeOrEqualsTimestamp(this.timeStamp);
            List<Segment> segments = reader.getReplayableSnapshotSegmentsUntil(index);
            this.writeSegmentsToFile(segments);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void writeSegmentsToFile(List<Segment> segmentsRetrieved) throws IOException {
        File outputFile = Paths.get(this.outputFilePath, new String[0]).toFile();
        if (outputFile.exists()) {
            outputFile.delete();
            outputFile.createNewFile();
        }
        TagManager tagManager = new TagManager();
        this.outputStream = new FileOutputStream(outputFile, true);
        this.recordedTimestamp = this.timeStamp;
        if (outputFile.length() == 0L) {
            try {
                this.writeHeader();
            }
            catch (IOException ex) {
                Logger.getLogger(Writer.class.getName()).log(Level.SEVERE, "Warning! Encountered exception while writing header. Continuing to process the segments.", ex);
            }
        }
        for (Segment segment : segmentsRetrieved) {
            try {
                if (TagManager.isTag(this.tag)) {
                    segment.setTag(tagManager.asValidTag(this.tag));
                }
                IOUtils.write((byte[])segment.asBytes(), (OutputStream)this.outputStream);
            }
            catch (IOException ex) {
                Logger.getLogger(Writer.class.getName()).log(Level.SEVERE, "Warning! Encountered exception while writing segments. Continuing to process the rest of segments.", ex);
            }
        }
        IOUtils.closeQuietly((OutputStream)this.outputStream);
    }

    private void writeHeader() throws IOException {
        Header header = new Header();
        header.setTimestamp(this.recordedTimestamp);
        byte[] data = header.asBytes();
        IOUtils.write((byte[])data, (OutputStream)this.outputStream);
    }
}

