/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.sourcecode;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import tdl.record.sourcecode.Command;
import tdl.record.sourcecode.snapshot.file.Reader;
import tdl.record.sourcecode.snapshot.file.Segment;

@Parameters(commandDescription="List snapshots in the file.")
public class ListCommand
extends Command {
    @Parameter(names={"-i", "--input"}, description="The SRCS input file.", required=true)
    public String inputFilePath;
    private List<String> gatheredInfo;

    @Override
    public void run() {
        File file = Paths.get(this.inputFilePath, new String[0]).toFile();
        try (Reader reader = new Reader(file);){
            Date start = new Date(reader.getFileHeader().getTimestamp());
            System.out.println("Recording Start Time: " + start.toString());
            int index = 0;
            this.gatheredInfo = new ArrayList<String>();
            while (reader.hasNext()) {
                Segment segment = reader.nextSegment();
                this.gatherInfo(segment, index);
                ++index;
            }
            this.printSnapshot();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<String> getGatheredInfo() {
        return this.gatheredInfo;
    }

    private void printSnapshot() {
        this.gatheredInfo.forEach(System.out::println);
    }

    private void gatherInfo(Segment segment, int index) {
        String type = segment.getSnapshot().getType().name();
        long size = segment.getSize() + 106L;
        String checksum = Hex.encodeHexString((byte[])segment.getChecksum());
        this.gatheredInfo.add(String.format("#%4d | time %4s | type %-5s | offset %10d | size %7d | checksum %8s.. | tag %s", index, segment.getTimestampSec(), type, segment.getAddress(), size, checksum.substring(0, 8), segment.getTag()));
    }
}

