/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.sourcecode;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import tdl.record.sourcecode.Command;
import tdl.record.sourcecode.content.CopyFromDirectorySourceCodeProvider;
import tdl.record.sourcecode.record.SourceCodeRecorder;
import tdl.record.sourcecode.time.SystemMonotonicTimeSource;

@Parameters(commandDescription="Start a recording session")
class RecordCommand
extends Command {
    @Parameter(names={"-s", "--source"}, description="The target sourceCodeProvider that you want to record")
    private String sourceCodePath;
    @Parameter(names={"-o", "--output"}, description="The destination file")
    private String outputPath;
    @Parameter(names={"-y", "--delay"}, description="The delay between two consecutive snapshots")
    private Integer delay = 5;
    @Parameter(names={"-ks", "--key-spacing"}, description="The spacing between two key snapshots")
    private Integer keySnapshotSpacing = 5;
    @Parameter(names={"-mxfs", "--max-allowed-file-size-mb"}, description="Maximum allowed file size of source files to capture")
    private int maximumFileSizeLimitInMB = 1;
    private SourceCodeRecorder sourceCodeRecorder;
    private Scanner stdin;

    RecordCommand() {
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void doRun() throws InterruptedException {
        CopyFromDirectorySourceCodeProvider sourceCodeProvider = new CopyFromDirectorySourceCodeProvider(Paths.get(this.sourceCodePath, new String[0]), this.maximumFileSizeLimitInMB);
        Path outputRecordingFilePath = Paths.get(this.outputPath, new String[0]);
        this.sourceCodeRecorder = new SourceCodeRecorder.Builder(sourceCodeProvider, outputRecordingFilePath).withTimeSource(new SystemMonotonicTimeSource()).withSnapshotEvery(this.delay, TimeUnit.SECONDS).withKeySnapshotSpacing(this.keySnapshotSpacing).build();
        this.registerSigtermHandler();
        Thread recordingThread = new Thread(() -> {
            try {
                this.sourceCodeRecorder.start(Duration.of(999L, ChronoUnit.HOURS));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        recordingThread.start();
        recordingThread.join();
    }

    private void registerSigtermHandler() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.sourceCodeRecorder.stop();
            this.sourceCodeRecorder.close();
        }));
    }
}

