/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.sourcecode.content;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.ignore.FastIgnoreRule;
import tdl.record.sourcecode.content.CombinedFileFilter;
import tdl.record.sourcecode.content.ExcludeGitDirectoryFileFilter;
import tdl.record.sourcecode.content.IgnoreRulesFilter;
import tdl.record.sourcecode.content.MaximumFileSizeLimitFilter;
import tdl.record.sourcecode.content.SourceCodeProvider;
import tdl.record.sourcecode.snapshot.SnapshotTypeHint;
import tdl.record.sourcecode.snapshot.helpers.GitHelper;

public class CopyFromDirectorySourceCodeProvider
implements SourceCodeProvider {
    private final Path sourceFolderPath;
    private final int maximumFileSizeLimitInMB;

    public CopyFromDirectorySourceCodeProvider(Path sourceFolderPath, int maximumFileSizeLimitInMB) {
        this.sourceFolderPath = sourceFolderPath;
        this.maximumFileSizeLimitInMB = maximumFileSizeLimitInMB;
    }

    @Override
    public SnapshotTypeHint retrieveAndSaveTo(Path destinationFolder) throws IOException {
        List<FastIgnoreRule> ignoreRules = GitHelper.getIgnoredFiles(this.sourceFolderPath);
        this.copyDirectory(destinationFolder, ignoreRules);
        return SnapshotTypeHint.ANY;
    }

    private void copyDirectory(Path destinationFolder, List<FastIgnoreRule> ignoreRules) throws IOException {
        CombinedFileFilter combinedFilter = new CombinedFileFilter(new ExcludeGitDirectoryFileFilter(this.sourceFolderPath), new IgnoreRulesFilter(this.sourceFolderPath, ignoreRules), new MaximumFileSizeLimitFilter((long)this.maximumFileSizeLimitInMB * 0x100000L));
        FileUtils.copyDirectory((File)this.sourceFolderPath.toFile(), (File)destinationFolder.toFile(), (FileFilter)combinedFilter);
    }
}

