/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.sourcecode.content;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.eclipse.jgit.ignore.FastIgnoreRule;

class IgnoreRulesFilter
implements FileFilter,
IOFileFilter {
    private final Path rootDir;
    private final List<FastIgnoreRule> ignoreRules;

    IgnoreRulesFilter(Path rootDir, List<FastIgnoreRule> ignoreRules) {
        this.rootDir = rootDir;
        this.ignoreRules = ignoreRules;
    }

    @Override
    public boolean accept(File targetPath) {
        boolean isDirectory;
        Path relativePath = this.rootDir.relativize(targetPath.toPath());
        return !this.matchesIgnoreRule(relativePath, isDirectory = targetPath.isDirectory());
    }

    public boolean accept(File dir, String targetPath) {
        return this.accept(dir.toPath().resolve(targetPath).toFile());
    }

    private boolean matchesIgnoreRule(Path targetPath, boolean isDirectory) {
        boolean matchesIgnoreRule = false;
        String pathAsString = targetPath.toString();
        for (FastIgnoreRule ignoreRule : this.ignoreRules) {
            matchesIgnoreRule |= ignoreRule.isMatch(pathAsString, isDirectory);
        }
        return matchesIgnoreRule;
    }
}

