/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.sourcecode.snapshot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import tdl.record.sourcecode.content.ExcludeGitDirectoryFileFilter;
import tdl.record.sourcecode.snapshot.Snapshot;
import tdl.record.sourcecode.snapshot.SnapshotType;
import tdl.record.sourcecode.snapshot.helpers.GitHelper;

public class KeySnapshot
extends Snapshot {
    public static int ZIP_BUFFER_SIZE = 1024;

    private KeySnapshot() {
        super(SnapshotType.KEY);
    }

    public static KeySnapshot takeSnapshotFromGit(Git git) {
        KeySnapshot keySnapshot = new KeySnapshot();
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GitHelper.exportArchive(git, os);
            keySnapshot.data = os.toByteArray();
        }
        catch (IOException | GitAPIException ex) {
            throw new RuntimeException(ex);
        }
        return keySnapshot;
    }

    public static KeySnapshot createSnapshotFromBytes(byte[] data) {
        KeySnapshot snapshot = new KeySnapshot();
        snapshot.data = data;
        return snapshot;
    }

    @Override
    public void restoreSnapshot(Git git) throws Exception {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(this.data);){
            File outputDir = git.getRepository().getWorkTree();
            this.cleanDirectory(outputDir);
            KeySnapshot.unzip(inputStream, outputDir);
        }
    }

    private void cleanDirectory(File directory) {
        ExcludeGitDirectoryFileFilter filter = new ExcludeGitDirectoryFileFilter(directory.toPath());
        FileUtils.listFiles((File)directory, (IOFileFilter)filter, (IOFileFilter)filter).forEach(File::delete);
    }

    private static void unzip(InputStream inputStream, File outputDir) {
        Path outputPath = outputDir.toPath();
        try (ZipInputStream zis = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                KeySnapshot.extractEntry(zis, entry, outputPath);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void extractEntry(ZipInputStream zis, ZipEntry entry, Path outputPath) throws IOException {
        Path newFilePath = outputPath.resolve(entry.getName());
        if (entry.isDirectory()) {
            Files.createDirectories(newFilePath, new FileAttribute[0]);
            return;
        }
        if (!Files.exists(newFilePath.getParent(), new LinkOption[0])) {
            Files.createDirectories(newFilePath.getParent(), new FileAttribute[0]);
        }
        try (OutputStream bos = Files.newOutputStream(newFilePath, new OpenOption[0]);){
            int location;
            byte[] buffer = new byte[1024];
            while ((location = zis.read(buffer)) != -1) {
                bos.write(buffer, 0, location);
            }
        }
    }
}

