/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.sourcecode.snapshot.file;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import tdl.record.sourcecode.snapshot.helpers.ByteHelper;

public class Header {
    public static int SIZE = 14;
    public static final byte[] MAGIC_BYTES = new byte[]{83, 82, 67, 83, 84, 77};
    private long timestamp;
    private byte[] magicBytes = MAGIC_BYTES;

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public byte[] getMagicBytes() {
        return this.magicBytes;
    }

    public void setMagicBytes(byte[] magicBytes) {
        this.magicBytes = magicBytes;
    }

    public boolean isValid() {
        return Arrays.equals(this.getMagicBytes(), MAGIC_BYTES);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] asBytes() {
        try (ByteArrayOutputStream byteArray = new ByteArrayOutputStream();){
            byteArray.write(this.getMagicBytes());
            byteArray.write(ByteHelper.littleEndianLongToByteArray(this.getTimestamp(), 8));
            byte[] byArray = byteArray.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            return new byte[0];
        }
    }
}

