/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.sourcecode.snapshot.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import tdl.record.sourcecode.snapshot.KeySnapshot;
import tdl.record.sourcecode.snapshot.SnapshotType;
import tdl.record.sourcecode.snapshot.file.Header;
import tdl.record.sourcecode.snapshot.file.Segment;
import tdl.record.sourcecode.snapshot.helpers.ByteHelper;

public class Reader
implements Iterator<Integer>,
AutoCloseable {
    private final File file;
    private final RandomAccessFile randomAccessFile;
    private Header fileHeader;

    public Reader(File file) throws IOException {
        this.file = file;
        this.randomAccessFile = new RandomAccessFile(file, "r");
        this.reset();
    }

    private byte[] readBytesFromOffset(int offset, int length) throws IOException {
        byte[] bytes = new byte[length];
        long lastPosition = this.randomAccessFile.getFilePointer();
        this.randomAccessFile.seek(offset);
        this.randomAccessFile.read(bytes, 0, length);
        this.randomAccessFile.seek(lastPosition);
        return bytes;
    }

    private long readLong(int offset) throws IOException {
        return ByteHelper.byteArrayToLittleEndianLong(this.readBytesFromOffset(offset, 8));
    }

    private byte[] readBytes(int length) throws IOException {
        byte[] bytes = new byte[length];
        this.randomAccessFile.read(bytes, 0, length);
        return bytes;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.randomAccessFile.getFilePointer() < this.randomAccessFile.length() - 1L;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public Integer next() {
        try {
            long address = this.randomAccessFile.getFilePointer();
            long size = this.readSegmentSizeFromAddress((int)address);
            int skip = 106 + (int)size;
            this.randomAccessFile.skipBytes(skip);
            return (int)address;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public Segment nextSegment() throws IOException {
        int address = this.next();
        return this.readSegmentByAddress(address);
    }

    private Header readFileHeader() throws IOException {
        Header header = new Header();
        header.setMagicBytes(this.readBytesFromOffset(0, Header.MAGIC_BYTES.length));
        header.setTimestamp(this.readLong(6));
        if (!header.isValid()) {
            throw new IOException("Cannot parse header");
        }
        this.randomAccessFile.seek(Header.SIZE);
        return header;
    }

    private long readSegmentSizeFromAddress(int address) throws IOException {
        return this.readLong(address + 14);
    }

    @Override
    public void remove() {
        Iterator.super.remove();
    }

    @Override
    public void forEachRemaining(Consumer<? super Integer> action) {
        Iterator.super.forEachRemaining(action);
    }

    public final void reset() throws IOException {
        this.randomAccessFile.seek(0L);
        this.fileHeader = this.readFileHeader();
    }

    public long getFilePointer() {
        try {
            return this.randomAccessFile.getFilePointer();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Header getFileHeader() {
        return this.fileHeader;
    }

    public void skip() {
        this.next();
    }

    public List<Integer> getSegmentAddresses() throws IOException {
        this.reset();
        ArrayList<Integer> list = new ArrayList<Integer>();
        this.forEachRemaining((Consumer<? super Integer>)((Consumer<Integer>)list::add));
        return list;
    }

    public List<Segment> getReplayableSnapshotSegmentsUntil(int index) throws Exception {
        Segment snapshot = this.getSnapshotAt(index);
        if (snapshot.getSnapshot() instanceof KeySnapshot) {
            return Collections.singletonList(snapshot);
        }
        int first = this.getFirstKeySnapshotBefore(index);
        return this.getSnapshotSegmentsByRange(first, index + 1);
    }

    public List<Segment> getSnapshotSegmentsByRange(int start, int end) throws IOException {
        ArrayList<Segment> list = new ArrayList<Segment>();
        this.reset();
        for (int index = 0; index < end; ++index) {
            if (index >= start) {
                Segment snapshot = this.nextSegment();
                list.add(snapshot);
                continue;
            }
            this.skip();
        }
        this.reset();
        return list;
    }

    public int getFirstKeySnapshotBefore(int index) throws IOException {
        int keyIndex = 0;
        this.reset();
        for (int start = 0; start < index; ++start) {
            Segment snapshot = this.nextSegment();
            if (!(snapshot.getSnapshot() instanceof KeySnapshot)) continue;
            keyIndex = start;
        }
        this.reset();
        return keyIndex;
    }

    public Segment readSegmentByAddress(int address) throws IOException {
        long lastPosition = this.randomAccessFile.getFilePointer();
        this.randomAccessFile.seek(address);
        Segment segment = new Segment();
        segment.setAddress(address);
        segment.setType(SnapshotType.fromMagicBytes(this.readBytes(6)));
        segment.setTimestampSec(ByteHelper.byteArrayToLittleEndianInt(this.readBytes(8)));
        segment.setSize(ByteHelper.byteArrayToLittleEndianInt(this.readBytes(8)));
        segment.setTag(this.asString(this.readBytes(64)));
        segment.setChecksum(this.readBytes(20));
        segment.setData(this.readBytes((int)segment.getSize()));
        if (segment.isChecksumMismatch()) {
            throw new IOException("Checksum mismatch");
        }
        this.randomAccessFile.seek(lastPosition);
        return segment;
    }

    private String asString(byte[] bytes) {
        int indexOfZero = Arrays.binarySearch(bytes, (byte)0);
        int newLength = bytes.length;
        if (indexOfZero >= 0) {
            newLength = indexOfZero;
        }
        return new String(bytes, 0, newLength).trim();
    }

    private Segment generateEmptySegment() {
        Segment segment = new Segment();
        segment.setType(SnapshotType.EMPTY);
        byte[] bytes = new byte[]{};
        segment.setData(bytes);
        segment.setTimestampSec(0L);
        segment.generateFromData();
        return segment;
    }

    public Segment getSnapshotAt(int index) throws IOException {
        this.reset();
        for (int start = 0; start < index; ++start) {
            this.skip();
        }
        int address = this.next();
        Segment snapshot = this.readSegmentByAddress(address);
        this.reset();
        return snapshot;
    }

    public List<Segment> getSegments() throws IOException {
        ArrayList<Segment> list = new ArrayList<Segment>();
        this.reset();
        this.forEachRemaining((Consumer<? super Integer>)((Consumer<Integer>)address -> {
            Segment segment;
            try {
                segment = this.readSegmentByAddress((int)address);
            }
            catch (IOException ex) {
                segment = this.generateEmptySegment();
            }
            list.add(segment);
        }));
        return list;
    }

    public int getIndexBeforeForTag(String tag) throws IOException {
        Segment segment;
        int index = 0;
        this.reset();
        while (!Objects.equals((segment = this.nextSegment()).getTag(), tag)) {
            ++index;
            if (this.hasNext()) continue;
        }
        this.reset();
        return index;
    }

    public int getIndexBeforeOrEqualsTimestamp(long timestamp) throws IOException {
        int index = 0;
        this.reset();
        do {
            Segment segment;
            if ((segment = this.nextSegment()).getTimestampSec() > timestamp) {
                --index;
                break;
            }
            ++index;
        } while (this.hasNext());
        this.reset();
        return index;
    }

    @Override
    public void close() {
        try {
            this.randomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public File getFile() {
        return this.file;
    }
}

