/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.sourcecode.snapshot.file;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.lib.Repository;

public class TagManager {
    private final Set<String> existingTags = new HashSet<String>();

    public static boolean isTag(String tag) {
        return tag != null && tag.trim().length() > 0;
    }

    public void addExisting(List<String> tags) {
        this.existingTags.addAll(tags);
    }

    String asUniqueTag(String tag) {
        String sanitisedTag = TagManager.sanitize(tag);
        String selectedTag = this.ensureUnique(sanitisedTag);
        this.existingTags.add(selectedTag);
        return selectedTag;
    }

    public String asValidTag(String tag) {
        String trimmedTag = TagManager.sanitize(tag);
        this.existingTags.add(trimmedTag);
        return trimmedTag;
    }

    private String ensureUnique(String trimmedTag) {
        String selectedTag = "";
        if (this.existingTags.contains(trimmedTag)) {
            for (int i = 2; i < 100; ++i) {
                String candidate = String.format("%s_%d", trimmedTag, i);
                if (this.existingTags.contains(candidate)) continue;
                selectedTag = candidate;
                break;
            }
        }
        if (selectedTag.isEmpty()) {
            selectedTag = trimmedTag;
        }
        return selectedTag;
    }

    private static String sanitize(String tag) {
        String normalizedTag = Repository.normalizeBranchName((String)tag);
        return normalizedTag.substring(0, Math.min(normalizedTag.length(), 64));
    }
}

