/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.sourcecode.snapshot.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.PersonIdent;
import tdl.record.sourcecode.snapshot.Snapshot;
import tdl.record.sourcecode.snapshot.file.Header;
import tdl.record.sourcecode.snapshot.file.Reader;
import tdl.record.sourcecode.snapshot.file.Segment;
import tdl.record.sourcecode.snapshot.file.TagManager;
import tdl.record.sourcecode.snapshot.helpers.GitHelper;

public class ToGitConverter {
    private final Path inputFile;
    private final Path outputDir;
    private Git git;
    private ProgressListener listener;
    private boolean stopOnErrors;
    private final TagManager tagManager;

    public ToGitConverter(Path inputFile, Path outputDir, ProgressListener listener, boolean stopOnErrors) throws IOException {
        this.inputFile = inputFile;
        this.outputDir = outputDir;
        this.listener = listener;
        this.stopOnErrors = stopOnErrors;
        this.tagManager = new TagManager();
        this.throwExceptionIfOutputDirInvalid();
    }

    public ToGitConverter(Path inputFile, Path outputDir) throws IOException {
        this(inputFile, outputDir, ToGitConverter.createDefaultListener(), true);
    }

    public void convert() throws Exception {
        this.initGit();
        Reader reader = new Reader(this.inputFile.toFile());
        while (reader.hasNext()) {
            this.processSegment(reader);
        }
    }

    private void processSegment(Reader reader) throws Exception {
        try {
            Header header = reader.getFileHeader();
            Segment segment = reader.nextSegment();
            this.listener.commitSegment(segment);
            this.writeDirFromSnapshot(segment);
            this.commitDirectory(header, segment);
        }
        catch (Exception e) {
            if (this.stopOnErrors) {
                throw e;
            }
            System.err.println(e.getMessage());
        }
    }

    private void writeDirFromSnapshot(Segment segment) throws Exception {
        Snapshot snapshot = segment.getSnapshot();
        snapshot.restoreSnapshot(this.git);
    }

    private void commitDirectory(Header header, Segment segment) throws GitAPIException {
        Date timestamp = new Date((header.getTimestamp() + segment.getTimestampSec()) * 1000L);
        PersonIdent origIdent = new PersonIdent(this.git.getRepository());
        PersonIdent ident = new PersonIdent(origIdent, timestamp);
        String message = timestamp.toString();
        this.git.add().addFilepattern(".").call();
        ToGitConverter.deleteMissing(this.git);
        this.git.commit().setAuthor(ident).setMessage(message).call();
        if (segment.hasTag()) {
            this.git.tag().setTagger(ident).setName(this.tagManager.asUniqueTag(segment.getTag())).call();
        }
    }

    private static void deleteMissing(Git git) throws GitAPIException {
        Status status = git.status().call();
        HashSet deletedFiles = new HashSet();
        deletedFiles.addAll(status.getMissing());
        deletedFiles.addAll(status.getRemoved());
        if (!deletedFiles.isEmpty()) {
            RmCommand rm = git.rm();
            deletedFiles.forEach(arg_0 -> ((RmCommand)rm).addFilepattern(arg_0));
            rm.call();
        }
    }

    private void initGit() throws GitAPIException, IOException {
        if (!GitHelper.isGitDirectory(this.outputDir)) {
            this.git = Git.init().setDirectory(this.outputDir.toFile()).call();
        } else {
            this.git = Git.open((File)this.outputDir.toFile());
            this.tagManager.addExisting(GitHelper.getTags(this.git));
        }
    }

    private void throwExceptionIfOutputDirInvalid() throws IOException {
        File dir = this.outputDir.toFile();
        if (!dir.exists()) {
            throw new IOException("Directory not found");
        }
        if (!dir.isDirectory()) {
            throw new IOException("No sourceCodeProvider found.");
        }
    }

    private static ProgressListener createDefaultListener() {
        return segment -> {};
    }

    @FunctionalInterface
    public static interface ProgressListener {
        public void commitSegment(Segment var1);
    }
}

