/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.sourcecode.snapshot.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class DirectoryZip
implements AutoCloseable {
    private final Path path;
    private final OutputStream out;
    private final ZipOutputStream zip;

    public DirectoryZip(Path path, OutputStream out) {
        this.path = path;
        this.out = out;
        this.zip = new ZipOutputStream(out);
    }

    public void compress() throws IOException {
        this.compressRecursive(this.path);
        IOUtils.closeQuietly((OutputStream)this.zip);
    }

    private void compressRecursive(Path subPath) throws IOException {
        for (File file : subPath.toFile().listFiles()) {
            Path filePath = file.toPath();
            if (file.isDirectory()) {
                this.compressRecursive(filePath);
                continue;
            }
            String name = filePath.toString().replace(this.path.toString(), "");
            ZipEntry entry = new ZipEntry(name);
            this.zip.putNextEntry(entry);
            FileInputStream in = new FileInputStream(file);
            IOUtils.copy((InputStream)in, (OutputStream)this.zip);
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((OutputStream)this.zip);
        IOUtils.closeQuietly((OutputStream)this.out);
    }
}

