/*
 * Decompiled with CFR 0.152.
 */
package tdl.record.sourcecode.time;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tdl.record.sourcecode.time.TimeSource;

public class SystemMonotonicTimeSource
implements TimeSource {
    private static final Logger log = LoggerFactory.getLogger(SystemMonotonicTimeSource.class);
    private final long referenceTime = System.nanoTime();
    private final Object lockObj = new Object();

    @Override
    public long currentTimeNano() {
        return System.nanoTime() - this.referenceTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeUpAt(long timestamp, TimeUnit timeUnit) throws InterruptedException {
        long currentTimestampNano = this.currentTimeNano();
        long targetTimestampNano = timeUnit.toNanos(timestamp);
        long timeToSleepMillis = TimeUnit.NANOSECONDS.toMillis(targetTimestampNano - currentTimestampNano);
        if (timeToSleepMillis > 1L) {
            log.debug("Sleep for: {} millis", (Object)timeToSleepMillis);
            Object object = this.lockObj;
            synchronized (object) {
                this.lockObj.wait(timeToSleepMillis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeUpNow() {
        Object object = this.lockObj;
        synchronized (object) {
            this.lockObj.notifyAll();
        }
    }
}

